/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.lazy;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.Model;
import java.io.ObjectOutputStream;
import java.util.Iterator;

public class AverageModel
extends Model {
    public AverageModel(Attribute label) {
        super(label);
    }

    public void writeData(ObjectOutputStream out) {
    }

    public void apply(ExampleSet exampleSet) {
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            double average = 0.0;
            for (int i = 0; i < example.getNumberOfAttributes(); ++i) {
                average += example.getValue(example.getAttribute(i));
            }
            average /= (double)example.getNumberOfAttributes();
            if (exampleSet.getPredictedLabel().isNominal()) {
                Attribute label = exampleSet.getPredictedLabel();
                double minDistance = Double.POSITIVE_INFINITY;
                int prediction = -1;
                Iterator i = label.getValues().iterator();
                while (i.hasNext()) {
                    String classValue = (String)i.next();
                    int classIndex = label.mapString(classValue);
                    double distance = Math.abs((double)classIndex - average);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                    prediction = classIndex;
                }
                example.setPredictedLabel(prediction);
                example.setConfidence(this.getLabel().mapIndex(prediction), 1.0);
                continue;
            }
            example.setPredictedLabel(average);
        }
    }
}

