/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Mutation;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Population;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PopulationOperator;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;

public class VarianceAdaption
implements PopulationOperator {
    private static final int WAIT_INTERVALS = 1;
    private static final double FACTOR = 0.65;
    private Mutation mutation = null;
    private int intervalSize;
    private LinkedList successList = new LinkedList();

    public VarianceAdaption(Mutation mutation, int intervalSize) {
        this.mutation = mutation;
        this.intervalSize = intervalSize;
    }

    public void operate(Population population) {
        if (population.getGenerationsWithoutImprovement() < 2) {
            this.successList.add(new Boolean(true));
        } else {
            this.successList.add(new Boolean(false));
        }
        if (population.getGeneration() >= 1 * this.intervalSize) {
            this.successList.removeFirst();
            if (population.getGeneration() % this.intervalSize == 0) {
                int successCount = 0;
                Iterator i = this.successList.iterator();
                while (i.hasNext()) {
                    if (!((Boolean)i.next()).booleanValue()) continue;
                    ++successCount;
                }
                if ((double)successCount / (double)(1 * this.intervalSize) < 0.2) {
                    this.mutation.setVariance(this.mutation.getVariance() * 0.65);
                    LogService.logMessage("Applying 1/5-rule: shrink variance!", 2);
                } else {
                    this.mutation.setVariance(this.mutation.getVariance() / 0.65);
                    LogService.logMessage("Applying 1/5-rule: enlarge variance!", 2);
                }
            }
        }
    }
}

