/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SigmoidKernel
extends Kernel {
    private double a = 1.0;
    private double b = 0.0;

    public int getType() {
        return 3;
    }

    public void setSigmoidParameters(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        double prod = this.a * this.innerProduct(x1, x2) + this.b;
        double e1 = Math.exp(prod);
        double e2 = Math.exp(-prod);
        return (e1 - e2) / (e1 + e2);
    }

    public void readKernelParameters(ObjectInputStream in) throws IOException {
        this.a = in.readDouble();
        this.b = in.readDouble();
    }

    public void writeKernelParameters(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.a);
        out.writeDouble(this.b);
    }
}

