/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.SimplePlotterDialog;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.ClassificationOptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoSVMModel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.OptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RegressionOptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.math.optimization.ec.pso.PSOOptimization;
import java.util.LinkedList;

public class PSOSVMOptimization
extends PSOOptimization {
    private static final double IS_ZERO = 1.0E-10;
    private ExampleSet exampleSet;
    private Kernel kernel;
    private double c;
    private double epsilon = 0.0;
    private int maxIterations;
    private int generationsWithoutImprovement;
    private double[] ys;
    private OptimizationFunction optimizationFunction;
    private boolean showPlot = false;
    private Statistics stats;
    private SimplePlotterDialog plotter;

    public PSOSVMOptimization(ExampleSet exampleSet, Kernel kernel, double c, int maxIterations, int generationsWithoutImprovement, int popSize, double inertiaWeight, double localWeight, double globalWeight, boolean dynamicInertiaWeight, boolean showPlot) {
        super(popSize < 1 ? exampleSet.getSize() : popSize, exampleSet.getSize(), maxIterations, generationsWithoutImprovement, inertiaWeight, localWeight, globalWeight, 0.0, 1.0, dynamicInertiaWeight);
        boolean regression;
        this.exampleSet = exampleSet;
        this.kernel = kernel;
        this.kernel.init(exampleSet);
        this.c = c;
        if (this.c <= 0.0) {
            this.c = 0.0;
            for (int i = 0; i < exampleSet.getSize(); ++i) {
                this.c += kernel.getDistance(i, i);
            }
            this.c = (double)exampleSet.getSize() / this.c;
            LogService.logMessage("Determine probably good value for C: set to " + this.c, 2);
        }
        this.setMinValue(0.0);
        this.setMaxValue(this.c);
        this.ys = new double[exampleSet.getSize()];
        ExampleReader reader = exampleSet.getExampleReader();
        int index = 0;
        Attribute label = exampleSet.getLabel();
        boolean bl = regression = !label.isBooleanClassification();
        while (reader.hasNext()) {
            Example example = reader.next();
            if (!regression) {
                this.ys[index++] = example.getLabel() == (double)label.getPositiveIndex() ? 1.0 : -1.0;
                continue;
            }
            this.ys[index++] = example.getLabel();
        }
        this.optimizationFunction = !regression ? new ClassificationOptimizationFunction() : new RegressionOptimizationFunction(this.epsilon);
        this.showPlot = showPlot;
        if (showPlot) {
            this.stats = new Statistics("Fitness vs. Generations");
            this.stats.init(new String[]{"Generations", "Fitness"});
            this.stats.init(new String[]{"Generations", "Best Fitness", "Current Fitness"});
            this.plotter = new SimplePlotterDialog(this.stats, false);
            this.plotter.setXAxis(0);
            this.plotter.plotColumn(1, true);
            this.plotter.plotColumn(2, true);
            this.plotter.setVisible(true);
        }
    }

    public void nextIteration() {
        if (this.showPlot) {
            this.stats.add(new Object[]{new Double(this.getGeneration()), new Double(this.getBestFitnessEver()), new Double(this.getBestFitnessInGeneration())});
        }
    }

    public PerformanceVector evaluateIndividual(double[] individual) {
        double fitness = this.optimizationFunction.getFunctionValue(individual, this.ys, this.kernel);
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("SVMOptValue", fitness, 1, false));
        return result;
    }

    public EvoSVMModel getModel(double[] alphas) {
        int i;
        if (this.showPlot) {
            this.plotter.dispose();
        }
        ExampleReader reader = this.exampleSet.getExampleReader();
        LinkedList<SupportVector> supportVectors = new LinkedList<SupportVector>();
        int index = 0;
        while (reader.hasNext()) {
            double currentAlpha = alphas[index];
            Example currentExample = reader.next();
            if (currentAlpha != 0.0) {
                double[] x = new double[this.exampleSet.getNumberOfAttributes()];
                for (int a = 0; a < x.length; ++a) {
                    x[a] = currentExample.getValue(this.exampleSet.getAttribute(a));
                }
                supportVectors.add(new SupportVector(x, this.ys[index], currentAlpha));
            }
            ++index;
        }
        double[] sum = new double[this.exampleSet.getSize()];
        reader = this.exampleSet.getExampleReader();
        index = 0;
        while (reader.hasNext()) {
            Example current = reader.next();
            double[] x = new double[this.exampleSet.getNumberOfAttributes()];
            for (int a = 0; a < x.length; ++a) {
                x[a] = current.getValue(this.exampleSet.getAttribute(a));
            }
            sum[index] = this.kernel.getSum(supportVectors, x);
            ++index;
        }
        double bSum = 0.0;
        int bCounter = 0;
        for (i = 0; i < alphas.length; ++i) {
            if (this.ys[i] * alphas[i] - this.c < -1.0E-10 && this.ys[i] * alphas[i] > 1.0E-10) {
                bSum += this.ys[i] - sum[i] - this.epsilon;
                ++bCounter;
                continue;
            }
            if (!(this.ys[i] * alphas[i] + this.c > 1.0E-10) || !(this.ys[i] * alphas[i] < -1.0E-10)) continue;
            bSum += this.ys[i] - sum[i] - this.epsilon;
            ++bCounter;
        }
        if (bCounter == 0) {
            bSum = 0.0;
            for (i = 0; i < alphas.length; ++i) {
                if (!(this.ys[i] * alphas[i] < 1.0E-10) || !(this.ys[i] * alphas[i] > -1.0E-10)) continue;
                bSum += this.ys[i] - sum[i];
                ++bCounter;
            }
            if (bCounter == 0) {
                bSum = 0.0;
                for (i = 0; i < alphas.length; ++i) {
                    bSum += this.ys[i] - sum[i];
                    ++bCounter;
                }
            }
        }
        return new EvoSVMModel(this.exampleSet.getLabel(), supportVectors, this.kernel, bSum / (double)bCounter);
    }
}

