/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.DotKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PolynomialKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RBFKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SigmoidKernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;

public abstract class Kernel {
    public static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "sigmoid"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_SIGMOID = 3;
    private double[][] distances;

    public abstract int getType();

    public abstract double calculateDistance(double[] var1, double[] var2);

    public abstract void writeKernelParameters(ObjectOutputStream var1) throws IOException;

    public abstract void readKernelParameters(ObjectInputStream var1) throws IOException;

    public void init(ExampleSet exampleSet) {
        int size = exampleSet.getSize();
        this.distances = new double[size][size];
        ExampleReader reader = exampleSet.getExampleReader();
        int i = 0;
        while (reader.hasNext()) {
            Example example1 = reader.next();
            double[] x1 = new double[exampleSet.getNumberOfAttributes()];
            for (int x = 0; x < x1.length; ++x) {
                x1[x] = example1.getValue(exampleSet.getAttribute(x));
            }
            ExampleReader innerReader = exampleSet.getExampleReader();
            int j = 0;
            while (innerReader.hasNext()) {
                double distance;
                Example example2 = innerReader.next();
                double[] x2 = new double[exampleSet.getNumberOfAttributes()];
                for (int x = 0; x < x2.length; ++x) {
                    x2[x] = example2.getValue(exampleSet.getAttribute(x));
                }
                this.distances[i][j] = distance = this.calculateDistance(x1, x2);
                this.distances[j][i] = distance;
                ++j;
            }
            ++i;
        }
    }

    public double getDistance(int x1, int x2) {
        return this.distances[x1][x2];
    }

    public double innerProduct(double[] x1, double[] x2) {
        double result = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            result += x1[i] * x2[i];
        }
        return result;
    }

    public double norm2(double[] x1, double[] x2) {
        double result = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            double factor = x1[i] - x2[i];
            result += factor * factor;
        }
        return result;
    }

    public double getSum(Collection supportVectors, double[] currentX) {
        double sum = 0.0;
        Iterator i = supportVectors.iterator();
        while (i.hasNext()) {
            SupportVector sv = (SupportVector)i.next();
            sum += sv.getY() * sv.getAlpha() * this.calculateDistance(sv.getX(), currentX);
        }
        return sum;
    }

    public void writeKernelData(ObjectOutputStream out) throws IOException {
        out.writeInt(this.getType());
        this.writeKernelParameters(out);
    }

    public static Kernel readKernelData(ObjectInputStream in) throws IOException {
        int type = in.readInt();
        Kernel kernel = Kernel.createKernel(type);
        kernel.readKernelParameters(in);
        return kernel;
    }

    public static Kernel createKernel(int kernelType) {
        if (kernelType == 0) {
            return new DotKernel();
        }
        if (kernelType == 1) {
            return new RBFKernel();
        }
        if (kernelType == 2) {
            return new PolynomialKernel();
        }
        if (kernelType == 3) {
            return new SigmoidKernel();
        }
        return null;
    }
}

