/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.learner.IOModel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EvoSVMModel
extends IOModel {
    private Kernel kernel;
    private List supportVectors;
    private double bias;
    private int numberOfAttributes;

    public EvoSVMModel(Attribute label) {
        super(label);
    }

    public EvoSVMModel(Attribute label, List supportVectors, Kernel kernel, double bias) {
        super(label);
        this.supportVectors = supportVectors;
        if (supportVectors == null || supportVectors.size() == 0) {
            throw new RuntimeException("Null or empty support vector collection: not possible to predict values!");
        }
        this.numberOfAttributes = ((SupportVector)supportVectors.get(0)).getX().length;
        this.kernel = kernel;
        this.bias = bias;
    }

    public void apply(ExampleSet exampleSet) {
        if (exampleSet.getNumberOfAttributes() != this.numberOfAttributes) {
            throw new RuntimeException("Cannot apply model: incompatible numbers of attributes (" + exampleSet.getNumberOfAttributes() + " != " + this.numberOfAttributes + ")!");
        }
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example current = reader.next();
            double[] currentX = new double[exampleSet.getNumberOfAttributes()];
            for (int x = 0; x < currentX.length; ++x) {
                currentX[x] = current.getValue(exampleSet.getAttribute(x));
            }
            double sum = this.bias + this.kernel.getSum(this.supportVectors, currentX);
            int index = sum > 0.0 ? this.getLabel().getPositiveIndex() : this.getLabel().getNegativeIndex();
            current.setPredictedLabel(index);
            current.setConfidence(this.getLabel().mapIndex(index), 1.0);
        }
    }

    public void readData(ObjectInputStream in) throws IOException {
        this.numberOfAttributes = in.readInt();
        int numSV = in.readInt();
        this.supportVectors = new ArrayList(numSV);
        for (int i = 0; i < numSV; ++i) {
            double[] x = new double[this.numberOfAttributes];
            for (int a = 0; a < this.numberOfAttributes; ++a) {
                x[a] = in.readDouble();
            }
            double y = in.readDouble();
            double alpha = in.readDouble();
            this.supportVectors.add(new SupportVector(x, y, alpha));
        }
        this.bias = in.readDouble();
        this.kernel = Kernel.readKernelData(in);
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(this.numberOfAttributes);
        out.writeInt(this.supportVectors.size());
        Iterator i = this.supportVectors.iterator();
        while (i.hasNext()) {
            SupportVector sv = (SupportVector)i.next();
            double[] x = sv.getX();
            for (int a = 0; a < this.numberOfAttributes; ++a) {
                out.writeDouble(x[a]);
            }
            out.writeDouble(sv.getY());
            out.writeDouble(sv.getAlpha());
        }
        out.writeDouble(this.bias);
        this.kernel.writeKernelData(out);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("EvoSVM Model\n");
        result.append("#SV: " + this.supportVectors.size() + "\n");
        result.append("b: " + this.bias + "\n");
        double[] w = new double[this.numberOfAttributes];
        Iterator i = this.supportVectors.iterator();
        while (i.hasNext()) {
            SupportVector sv = (SupportVector)i.next();
            double[] x = sv.getX();
            double alpha = sv.getAlpha();
            double y = sv.getY();
            for (int j = 0; j < w.length; ++j) {
                w[j] = y * alpha * x[j];
            }
        }
        for (int j = 0; j < w.length; ++j) {
            result.append("w[" + j + "]=" + w[j] + "\n");
        }
        i = this.supportVectors.iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index > 100) {
                result.append("... " + (this.supportVectors.size() - 100) + " SVs ...");
                break;
            }
            result.append(i.next() + "\n");
        }
        return result.toString();
    }
}

