/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FastExample2SparseTransform;
import edu.udo.cs.yale.operator.learner.IOModel;
import edu.udo.cs.yale.operator.learner.kernel.LibSVMLearner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import libsvm.svm;
import libsvm.svm_model;

public class LibSVMModel
extends IOModel {
    private svm_model model;

    public LibSVMModel(Attribute label) {
        super(label);
    }

    public LibSVMModel(Attribute label, svm_model model) {
        super(label);
        this.model = model;
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        svm.svm_save_model(out, this.model);
    }

    public void readData(ObjectInputStream in) throws IOException {
        this.model = svm.svm_load_model(in);
    }

    public void apply(ExampleSet exampleSet) {
        FastExample2SparseTransform ripper = new FastExample2SparseTransform(exampleSet);
        ExampleReader i = exampleSet.getExampleReader();
        while (i.hasNext()) {
            Example e = i.next();
            if (this.getLabel().isNominal()) {
                double[] classProbs = new double[this.getLabel().getNumberOfValues()];
                double value = svm.svm_predict_probability(this.model, LibSVMLearner.makeNodes(e, ripper), classProbs);
                e.setPredictedLabel(value);
                for (int k = 0; k < classProbs.length; ++k) {
                    e.setConfidence(this.getLabel().mapIndex(this.model.label[k]), classProbs[k]);
                }
                continue;
            }
            e.setPredictedLabel(svm.svm_predict(this.model, LibSVMLearner.makeNodes(e, ripper)));
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString() + "\n");
        result.append("number of classes: " + this.model.nr_class + "\n");
        if (this.getLabel().isNominal()) {
            for (int i = 0; i < this.model.nSV.length; ++i) {
                result.append("number of support vectors for class " + this.getLabel().mapIndex(this.model.label[i]) + ": " + this.model.nSV[i] + "\n");
            }
        } else {
            result.append("number of support vectors: " + this.model.l + "\n");
        }
        return result.toString();
    }
}

