/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.gui.PlotterPanel;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.IOModel;
import edu.udo.cs.yale.operator.learner.kernel.AbstractMySVMLearner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class AbstractMySVMModel
extends IOModel {
    private ExampleSet model;
    private Kernel kernel;
    private int kernelType;

    public AbstractMySVMModel(Attribute labelAttribute) {
        super(labelAttribute);
    }

    public AbstractMySVMModel(Attribute labelAttribute, ExampleSet model, Kernel kernel, int kernelType) {
        super(labelAttribute);
        this.model = model;
        this.kernel = kernel;
        this.kernelType = kernelType;
    }

    public abstract SVMInterface createSVM();

    public Kernel getKernel() {
        return this.kernel;
    }

    public ExampleSet getExampleSet() {
        return this.model;
    }

    public abstract void setPrediction(Example var1, double var2);

    public void readData(ObjectInputStream in) throws IOException {
        this.model = new ExampleSet(in);
        int kernelType = in.readInt();
        int cacheSize = in.readInt();
        this.kernel = AbstractMySVMLearner.createKernel(kernelType);
        this.kernel.readKernelParameters(in);
        this.kernel.init(this.model, cacheSize);
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        this.model.writeSupportVectors(out);
        out.writeInt(this.kernelType);
        out.writeInt(this.kernel.getCacheSize());
        this.kernel.writeKernelParameters(out);
    }

    public void apply(edu.udo.cs.yale.example.ExampleSet exampleSet) throws OperatorException {
        ExampleSet toPredict = new ExampleSet(exampleSet, exampleSet.getPredictedLabel(), this.model.getMeanVariances());
        SVMInterface svm2 = this.createSVM();
        svm2.init(this.kernel, this.model);
        svm2.predict(toPredict);
        ExampleReader reader = exampleSet.getExampleReader();
        int k = 0;
        while (reader.hasNext()) {
            this.setPrediction(reader.next(), toPredict.get_y(k++));
        }
    }

    public String toString() {
        return this.model.toString(0, false);
    }

    public String toResultString() {
        if (this.model.count_examples() < 500) {
            return this.model.toString(true);
        }
        return this.model.toString(500, true) + "\n...";
    }

    public Component getVisualisationComponent() {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        final JLabel label = new JLabel("<html>" + AbstractMySVMModel.toHTML(this.toResultString()) + "</html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        mainPanel.add((Component)label, "Center");
        Statistics stats = new Statistics("JMySVM model");
        String[] columnNames = new String[]{"counter", "alpha", "abs(alpha)"};
        stats.init(columnNames);
        LinkedList<AlphaValue> alphaValues = new LinkedList<AlphaValue>();
        LinkedList<AlphaValue> absAlphaValues = new LinkedList<AlphaValue>();
        for (int i = 0; i < this.model.count_examples(); ++i) {
            double alpha = this.model.get_alpha(i);
            if (alpha == 0.0) continue;
            alphaValues.add(new AlphaValue(this.model.getId(i), alpha));
            absAlphaValues.add(new AlphaValue(this.model.getId(i), Math.abs(alpha)));
        }
        Collections.sort(alphaValues);
        Collections.sort(absAlphaValues);
        Iterator i = alphaValues.iterator();
        Iterator j = absAlphaValues.iterator();
        int counter = 0;
        while (i.hasNext() && j.hasNext()) {
            AlphaValue currentAlpha = (AlphaValue)i.next();
            AlphaValue currentAbsAlpha = (AlphaValue)j.next();
            stats.add(currentAlpha.getId(), new Double[]{new Double(counter++), new Double(currentAlpha.getAlpha()), new Double(currentAbsAlpha.getAlpha())});
        }
        final PlotterPanel plotterPanel = new PlotterPanel(stats);
        final JRadioButton tableButton = new JRadioButton("table view", true);
        tableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tableButton.isSelected()) {
                    mainPanel.remove(plotterPanel);
                    mainPanel.add((Component)label, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("plot view", false);
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(label);
                    mainPanel.add((Component)plotterPanel, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(tableButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(tableButton);
        togglePanel.add(plotButton);
        mainPanel.add((Component)togglePanel, "North");
        return mainPanel;
    }

    private class AlphaValue
    implements Comparable {
        private double alpha;
        private String id;

        public AlphaValue(String id, double alpha) {
            this.id = id;
            this.alpha = alpha;
        }

        public String getId() {
            return this.id;
        }

        public double getAlpha() {
            return this.alpha;
        }

        public int compareTo(Object o) {
            return -1 * Double.compare(this.alpha, ((AlphaValue)o).alpha);
        }
    }
}

