/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeAttributeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleSource.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private String attributes;
    private int maxLines;
    private String separatorRegExpr;
    private char[] comments;
    private int dataRowType;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ExampleSource(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        String attributes = this.getParameterAsString("attributes");
        if (attributes == null || attributes.length() == 0) {
            throw new UserError((Operator)this, 205, "attributes");
        }
        int maxLines = this.getParameterAsInt("sample_size");
        String separatorRegExpr = this.getParameterAsString("column_separators");
        char[] comments = this.getParameterAsString("comment_chars").toCharArray();
        int dataRowType = this.getParameterAsInt("datamanagement");
        boolean useQuotes = this.getParameterAsBoolean("use_quotes");
        AttributeDataSources attributeDataSources = null;
        FileDataRowReader reader = null;
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(this.getExperiment().resolveFileName(attributes), true);
            reader = new FileDataRowReader(new DataRowFactory(dataRowType), attributeDataSources.getDataSources(), maxLines, separatorRegExpr, comments, useQuotes);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{attributes, e.getMessage()});
        }
        catch (XMLException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, (Object)e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, (Object)e.toString());
        }
        catch (SAXException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, (Object)e.toString());
        }
        AttributeSet attributeSet = new AttributeSet(attributeDataSources);
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader);
        ExampleSet result = table.createExampleSet(attributeSet);
        if (result.getSize() == 0) {
            throw new UserError(this, 117);
        }
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeAttributeFile("attributes", "Filename for the xml attribute description file. This file also contains the names of the files to read the data from.", false));
        ParameterTypeInt type = new ParameterTypeInt("sample_size", "The maximum number of examples to read from the data files (-1 = all)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString("column_separators", "Column separators for data files (regular expression)", ",?\\s|;?\\s|,|;"));
        types.add(new ParameterTypeString("comment_chars", "Lines beginning with these characters are ignored.", "#"));
        types.add(new ParameterTypeBoolean("use_quotes", "Indicates if quotes should be regarded (slower!).", false));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

