/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.ExampleFormatter;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SparseFormatDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class ExampleSetWriter
extends Operator {
    private static String[] formatNames = new String[SparseFormatDataRowReader.FORMAT_NAMES.length + 2];
    private static final int DENSE_FORMAT = 0;
    private String filename;
    private String attDescFile;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleSetWriter.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        this.filename = this.getParameterAsString("example_set_file");
        this.attDescFile = this.getParameterAsString("attribute_description_file");
        try {
            File dataFile = this.getExperiment().resolveFileName(this.filename);
            File attFile = this.attDescFile != null ? this.getExperiment().resolveFileName(this.attDescFile) : null;
            int format = this.getParameterAsInt("format");
            this.logMessage("Writing example set in format '" + formatNames[format] + "'.", 2);
            if (format == 0) {
                eSet.writeToFile(dataFile, attFile);
            } else if (format == formatNames.length - 1) {
                if (this.attDescFile != null) {
                    this.logMessage("special_format used. Ignoring attribute description file.", 6);
                }
                this.writeSpecialFormat(eSet, dataFile);
            } else {
                eSet.writeToFileSparse(format - 1, dataFile, attFile);
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{this.filename + " / " + this.attDescFile, e.getMessage()});
        }
        return new IOObject[]{eSet};
    }

    private void writeSpecialFormat(ExampleSet exampleSet, File dataFile) throws OperatorException {
        ExampleFormatter formatter;
        String format = this.getParameterAsString("special_format");
        if (format == null) {
            throw new UserError((Operator)this, 201, new Object[]{"special_format", "format", "special_format"});
        }
        try {
            formatter = ExampleFormatter.compile(format, exampleSet);
        }
        catch (Throwable e) {
            throw new UserError((Operator)this, 901, format, (Object)e.getMessage());
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(dataFile));
            ExampleReader reader = exampleSet.getExampleReader();
            while (reader.hasNext()) {
                out.print(formatter.format(reader.next()));
            }
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 301, new Object[]{dataFile, e.getMessage()});
        }
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleSetWriter.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleSetWriter.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("example_set_file", "File to save the example set to.", false));
        types.add(new ParameterTypeFile("attribute_description_file", "File to save the attribute descriptions to.", true));
        types.add(new ParameterTypeCategory("format", "Format to use for output.", formatNames, 0));
        types.add(new ParameterTypeString("special_format", "Format string to use for output.", true));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ExampleSetWriter.formatNames[0] = "dense";
        for (int i = 0; i < SparseFormatDataRowReader.FORMAT_NAMES.length; ++i) {
            ExampleSetWriter.formatNames[i + 1] = "sparse_" + SparseFormatDataRowReader.FORMAT_NAMES[i];
        }
        ExampleSetWriter.formatNames[ExampleSetWriter.formatNames.length - 1] = "special_format";
    }
}

