/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DatabaseExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.io.ResultSetExampleSource;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.DatabaseHandler;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DatabaseExampleSource
extends ResultSetExampleSource {
    private DatabaseHandler dbAccess;

    public DatabaseExampleSource(OperatorDescription description) {
        super(description);
    }

    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) {
        this.setNominalValuesForLabel(label);
    }

    public void setNominalValuesForLabel(Attribute label) {
        if (label != null) {
            String classes = this.getParameterAsString("classes");
            if (label.isNominal()) {
                if (classes != null) {
                    String[] labelClasses = classes.split(" ");
                    for (int i = 0; i < labelClasses.length; ++i) {
                        label.mapString(labelClasses[i].trim());
                    }
                }
            } else if (classes != null && classes.length() > 0) {
                LogService.logMessage("Ignoring classes for non-nominal attribute " + label.getName() + ".", 4);
            }
        }
    }

    public IOObject[] apply() throws OperatorException {
        if (!this.getParameterAsBoolean("work_on_database")) {
            IOObject[] output = super.apply();
            try {
                this.dbAccess.disconnect();
            }
            catch (SQLException sqle) {
                LogService.logException("Could not disconnect from Database!", sqle);
            }
            return output;
        }
        try {
            String tableName = this.getParameterAsString("table_name");
            if (tableName == null) {
                throw new UserError((Operator)this, 201, new Object[]{"work_on_database", "true", "table_name"});
            }
            DatabaseExampleTable table = DatabaseExampleTable.createDatabaseExampleTable(this.getConnectedDatabaseHandler(), tableName);
            return new IOObject[]{this.createExampleSet(table)};
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, (Object)e.getMessage());
        }
    }

    private String getQuery() throws OperatorException {
        String query = this.getParameterAsString("query");
        String parameterUsed = null;
        boolean warning = false;
        if (query == null) {
            String queryFileName = this.getParameterAsString("query_file");
            if (queryFileName != null) {
                File queryFile = this.getExperiment().resolveFileName(queryFileName);
                try {
                    query = Tools.readTextFile(queryFile);
                    parameterUsed = "query_file";
                }
                catch (IOException ioe) {
                    throw new UserError((Operator)this, (Throwable)ioe, 302, new Object[]{queryFileName, ioe.getMessage()});
                }
                if (query.length() == 0) {
                    throw new UserError((Operator)this, 205, queryFileName);
                }
            }
        } else {
            parameterUsed = "query";
            if (this.isParameterSet("query_file")) {
                warning = true;
            }
        }
        if (query == null) {
            if (this.isParameterSet("table_name")) {
                query = "select * from " + this.getParameterAsString("table_name");
                parameterUsed = "table_name";
            }
        } else if (this.isParameterSet("table_name")) {
            warning = true;
        }
        if (query == null) {
            throw new UserError((Operator)this, 202, new Object[]{"query", "query_file", "table_name"});
        }
        if (warning) {
            LogService.logMessage("Only one of the parameters 'query', 'query_file', and 'table_name' have to be set. Using value of '" + parameterUsed + "'.", 4);
        }
        return query;
    }

    public DatabaseHandler getConnectedDatabaseHandler() throws OperatorException, SQLException {
        String driver = this.getParameterAsString("driver");
        if (driver == null || driver.length() == 0) {
            throw new UserError((Operator)this, 203, new Object[]{"yale.tools.jdbc.driver", "driver"});
        }
        String urlprefix = this.getParameterAsString("urlprefix");
        String databasename = this.getParameterAsString("databasename");
        String username = this.getParameterAsString("username");
        String password = this.getParameterAsString("password");
        if (password == null) {
            password = Yale.getInputHandler().inputPassword(databasename + ": Password for user '" + username + "' required");
        }
        DatabaseHandler databaseHandler = new DatabaseHandler(databasename, urlprefix, driver);
        LogService.logMessage("Connecting to '" + urlprefix + "' (" + databasename + ").", 0);
        databaseHandler.connect(username, password, true);
        return databaseHandler;
    }

    public ResultSet getResultSet() throws OperatorException {
        ResultSet rs = null;
        try {
            this.dbAccess = this.getConnectedDatabaseHandler();
            String query = this.getQuery();
            LogService.logMessage("Executing query: '" + query + "'", 0);
            rs = this.dbAccess.query(query);
            LogService.logMessage("Query executed.", 0);
        }
        catch (SQLException sqle) {
            throw new UserError((Operator)this, (Throwable)sqle, 304, (Object)sqle.getMessage());
        }
        return rs;
    }

    public void experimentFinished() {
        if (this.dbAccess != null) {
            try {
                this.dbAccess.disconnect();
            }
            catch (SQLException e) {
                LogService.logMessage("Cannot disconnect from database: " + e, 6);
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean("work_on_database", "(EXPERIMENTAL!) If set to true, the data read from the database is NOT copied to main memory. All operations that change data will modify the database.", false));
        types.add(new ParameterTypeString("driver", "Name of the database driver.", System.getProperty("yale.tools.jdbc.driver")));
        types.add(new ParameterTypeString("urlprefix", "URL prefix of the database, e.g. 'jdbc:oracle:thin:@foo.bar:portnr:'", false));
        types.add(new ParameterTypeString("databasename", "Name of the database.", false));
        types.add(new ParameterTypeString("username", "Database username.", false));
        types.add(new ParameterTypePassword("password", "Password for the database."));
        types.add(new ParameterTypeString("classes", "Whitespace separated list of possible class values of the label attribute."));
        types.add(new ParameterTypeString("query", "SQL query. If not set, the query is read from the file specified by 'query_file'."));
        types.add(new ParameterTypeFile("query_file", "File containing the query. Only evaluated if 'query' is not set.", true));
        types.add(new ParameterTypeString("table_name", "Use this table if work_on_database is true or no other query is specified."));
        return types;
    }

    static {
        Yale.registerYaleProperty(new ParameterTypeString("yale.tools.jdbc.driver", "Default database driver class.", true));
    }
}

