/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.weighting.FeatureWeighting;
import edu.udo.cs.yale.operator.features.weighting.SimpleWeighting;
import edu.udo.cs.yale.tools.LogService;

public class ForwardWeighting
extends FeatureWeighting {
    public ForwardWeighting(OperatorDescription description) {
        super(description);
    }

    public PopulationOperator getWeightingOperator(String parameter) {
        double[] weights = new double[]{0.25, 0.5, 0.75, 1.0};
        if (parameter != null && parameter.length() != 0) {
            try {
                String[] weightStrings = parameter.split(" ");
                weights = new double[weightStrings.length];
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = Double.parseDouble(weightStrings[i]);
                }
            }
            catch (Exception e) {
                LogService.logMessage("Could not create weights: " + e.getMessage() + "! Use standard weights.", 6);
                weights = new double[]{0.25, 0.5, 0.75, 1.0};
            }
        }
        return new SimpleWeighting(0.0, weights);
    }

    public Population createInitialPopulation(ExampleSet es) {
        int i;
        Population initPop = new Population();
        AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
        for (i = 0; i < es.getNumberOfAttributes(); ++i) {
            nes.setWeight(i, 0.0);
        }
        for (i = 0; i < es.getNumberOfAttributes(); ++i) {
            AttributeWeightedExampleSet forwardES = (AttributeWeightedExampleSet)nes.clone();
            i = forwardES.setWeightForBlock(i, 1.0);
            initPop.add(forwardES);
        }
        return initPop;
    }
}

