/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.CorrelationMatrix;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import java.util.List;

public class CorrelationMatrixOperator
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$CorrelationMatrix;

    public CorrelationMatrixOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorrelationMatrixOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        CorrelationMatrix matrix = new CorrelationMatrix(exampleSet);
        int numberOfAttributes = exampleSet.getNumberOfAttributes();
        boolean squared = this.getParameterAsBoolean("squared_correlation");
        boolean createWeights = this.getParameterAsBoolean("create_weights");
        for (int i = 0; i < numberOfAttributes; ++i) {
            for (int j = i; j < numberOfAttributes; ++j) {
                matrix.setValue(i, j, this.getCorrelation(exampleSet, i, j, squared || createWeights));
            }
        }
        if (createWeights) {
            AttributeWeights weights = new AttributeWeights();
            for (int i = 0; i < numberOfAttributes; ++i) {
                double sum = 0.0;
                for (int j = 0; j < numberOfAttributes; ++j) {
                    sum += 1.0 - matrix.getValue(i, j);
                }
                weights.setWeight(exampleSet.getAttribute(i).getName(), sum / (double)numberOfAttributes);
            }
            return new IOObject[]{exampleSet, weights};
        }
        return new IOObject[]{exampleSet, matrix};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorrelationMatrixOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        Class[] classArray;
        if (this.getParameterAsBoolean("create_weights")) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorrelationMatrixOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet;
            classArray = classArray2;
            classArray2[1] = class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = CorrelationMatrixOperator.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorrelationMatrixOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet;
            classArray = classArray3;
            classArray3[1] = class$edu$udo$cs$yale$example$CorrelationMatrix == null ? (class$edu$udo$cs$yale$example$CorrelationMatrix = CorrelationMatrixOperator.class$("edu.udo.cs.yale.example.CorrelationMatrix")) : class$edu$udo$cs$yale$example$CorrelationMatrix;
        }
        return classArray;
    }

    private double getCorrelation(ExampleSet exampleSet, int firstIndex, int secondIndex, boolean squared) {
        double sumProd = 0.0;
        double sumFirst = 0.0;
        double sumSecond = 0.0;
        double sumFirstSquared = 0.0;
        double sumSecondSquared = 0.0;
        int counter = 0;
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            double second;
            Example example = reader.next();
            double first = example.getValue(firstIndex);
            double prod = first * (second = example.getValue(secondIndex));
            if (Double.isNaN(prod)) continue;
            sumProd += prod;
            sumFirst += first;
            sumFirstSquared += first * first;
            sumSecond += second;
            sumSecondSquared += second * second;
            ++counter;
        }
        double r = ((double)counter * sumProd - sumFirst * sumSecond) / Math.sqrt(((double)counter * sumFirstSquared - sumFirst * sumFirst) * ((double)counter * sumSecondSquared - sumSecond * sumSecond));
        if (squared) {
            return r * r;
        }
        return r;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("create_weights", "Indicates if attribute weights based on correlation should be calculated or if the complete matrix should be returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("squared_correlation", "Indicates if the squared correlation should be calculated.", false));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

