/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga.selection;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.ga.selection.Rank;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;

public class RankSelection
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;

    public RankSelection(int popSize, boolean keepBest) {
        this.popSize = popSize;
        this.keepBest = keepBest;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void operate(Population population) {
        LinkedList<ExampleSet> newGeneration = new LinkedList<ExampleSet>();
        if (this.keepBest) {
            AttributeWeightedExampleSet best = (AttributeWeightedExampleSet)population.bestEver().clone();
            newGeneration.add(best);
        }
        ArrayList<Rank> rankedIndividuals = new ArrayList<Rank>();
        double fitnessSum = 0.0;
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            fitnessSum += (double)i;
            rankedIndividuals.add(new Rank((ExampleSet)population.get(i).clone()));
        }
        Collections.sort(rankedIndividuals);
        while (newGeneration.size() < this.popSize) {
            double r = fitnessSum * RandomGenerator.getGlobalRandomGenerator().nextDouble();
            int j = -1;
            double f = 0.0;
            while ((f += (double)(++j)) < r) {
            }
            newGeneration.add(((Rank)rankedIndividuals.get(j)).getIndividual());
        }
        population.clear();
        ListIterator i = newGeneration.listIterator();
        while (i.hasNext()) {
            population.add((AttributeWeightedExampleSet)i.next());
        }
    }
}

