/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.ga.SelectionCrossover;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UnbalancedCrossover
extends SelectionCrossover {
    public UnbalancedCrossover(int type, double prob) {
        super(type, prob);
    }

    public void crossover(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2) {
        LinkedList<AttributeWeightContainer> dummyList1 = new LinkedList<AttributeWeightContainer>();
        LinkedList<AttributeWeightContainer> dummyList2 = new LinkedList<AttributeWeightContainer>();
        int maxSize = Math.max(es1.getNumberOfAttributes(), es2.getNumberOfAttributes());
        if (maxSize < 2) {
            return;
        }
        switch (this.getType()) {
            case 0: {
                Attribute attribute;
                double weight;
                int splitPoint = 1 + RandomGenerator.getGlobalRandomGenerator().nextInt(maxSize - 2);
                while (es1.getNumberOfAttributes() > splitPoint) {
                    weight = es1.getWeight(es1.getAttribute(splitPoint));
                    attribute = es1.removeAttribute(splitPoint);
                    dummyList1.add(new AttributeWeightContainer(attribute, weight));
                }
                while (es2.getNumberOfAttributes() > splitPoint) {
                    weight = es2.getWeight(es2.getAttribute(splitPoint));
                    attribute = es2.removeAttribute(splitPoint);
                    dummyList2.add(new AttributeWeightContainer(attribute, weight));
                }
                break;
            }
            case 1: {
                int i;
                for (i = es1.getNumberOfAttributes() - 1; i >= 0; --i) {
                    if (!RandomGenerator.getGlobalRandomGenerator().nextBoolean()) continue;
                    this.addAttributeToSwapList(es1, i, dummyList1);
                }
                for (i = es2.getNumberOfAttributes() - 1; i >= 0; --i) {
                    if (!RandomGenerator.getGlobalRandomGenerator().nextBoolean()) continue;
                    this.addAttributeToSwapList(es2, i, dummyList2);
                }
                break;
            }
            case 2: {
                double prob1 = (double)(RandomGenerator.getGlobalRandomGenerator().nextInt(es1.getNumberOfAttributes() - 1) + 1) / (double)es1.getNumberOfAttributes();
                for (int i = es1.getNumberOfAttributes() - 1; i >= 0; --i) {
                    if (!(RandomGenerator.getGlobalRandomGenerator().nextDouble() < prob1)) continue;
                    this.addAttributeToSwapList(es1, i, dummyList1);
                }
                double prob2 = (double)(RandomGenerator.getGlobalRandomGenerator().nextInt(es2.getNumberOfAttributes() - 1) + 1) / (double)es2.getNumberOfAttributes();
                for (int i = es2.getNumberOfAttributes() - 1; i >= 0; --i) {
                    if (!(RandomGenerator.getGlobalRandomGenerator().nextDouble() < prob2)) continue;
                    this.addAttributeToSwapList(es2, i, dummyList2);
                }
                break;
            }
        }
        this.mergeAttributes(es1, dummyList2);
        this.mergeAttributes(es2, dummyList1);
    }

    private void addAttributeToSwapList(AttributeWeightedExampleSet exampleSet, int index, List dummyList) {
        Attribute attribute = exampleSet.getAttribute(index);
        double weight = exampleSet.getWeight(attribute);
        exampleSet.removeAttribute(attribute);
        dummyList.add(new AttributeWeightContainer(attribute, weight));
    }

    private void mergeAttributes(AttributeWeightedExampleSet exampleSet, List attributeWeights) {
        Iterator i = attributeWeights.iterator();
        while (i.hasNext()) {
            AttributeWeightContainer attributeWeight = (AttributeWeightContainer)i.next();
            Attribute attribute = attributeWeight.getAttribute();
            if (exampleSet.getAttribute(attribute.getName()) == null) {
                exampleSet.addAttribute(attribute);
            }
            exampleSet.setWeight(attribute, attributeWeight.getWeight());
        }
    }

    private class AttributeWeightContainer {
        private Attribute attribute;
        private double weight;

        public AttributeWeightContainer(Attribute attribute, double weight) {
            this.attribute = attribute;
            this.weight = weight;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.attribute.getName() + "(" + this.weight + ")";
        }
    }
}

