/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.SinusFactory;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FourierGenerator;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.ga.FourierGeneratingMutation;
import edu.udo.cs.yale.operator.features.ga.YAGGA2;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;
import java.util.List;

public class FourierGGA
extends YAGGA2 {
    public FourierGGA(OperatorDescription description) {
        super(description);
    }

    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List generators = this.getGenerators();
        if (generators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
            attributes.add(eSet.getAttribute(i));
        }
        double pMutation = this.getParameterAsDouble("p_mutation");
        return new FourierGeneratingMutation(attributes, pMutation, generators, this.getParameterAsInt("number_constructed"), this.getParameterAsInt("number_original"), this.getParameterAsInt("search_fourier_peaks"), this.getParameterAsInt("adaption_type"), this.getParameterAsInt("attributes_per_peak"), this.getParameterAsDouble("epsilon"), this.getParameterAsInt("max_construction_depth"), this.getParameterAsString("unused_functions").split(" "));
    }

    protected List getPreProcessingPopulationOperators(ExampleSet eSet) {
        List popOps = super.getPreProcessingPopulationOperators(eSet);
        int startSinus = this.getParameterAsInt("start_sinus_boost");
        if (startSinus > 0) {
            FourierGenerator fourierGen = new FourierGenerator(this.getParameterAsInt("search_fourier_peaks"), this.getParameterAsInt("adaption_type"), this.getParameterAsInt("attributes_per_peak"), this.getParameterAsDouble("epsilon"));
            fourierGen.setStartGenerations(startSinus);
            fourierGen.setApplyInGeneration(0);
            popOps.add(fourierGen);
        }
        return popOps;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("number_original", "The maximum of original attributes added in each generation.", 0, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt("number_constructed", "The maximum number of attributes constructed in each generation.", 0, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt("max_construction_depth", "The maximum depth for the argument attributes used for attribute construction (-a: allow all depths).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeString("unused_functions", "Space separated list of functions which are not allowed in arguments for attribute construction."));
        types.add(new ParameterTypeInt("start_sinus_boost", "Uses a fourier generation in this first generations", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeInt("search_fourier_peaks", "Use this number of highest frequency peaks for sinus generation.", 0, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeInt("attributes_per_peak", "Use this number of additional peaks for each found peak.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeDouble("epsilon", "Use this range for additional peaks for each found peak.", 0.0, Double.POSITIVE_INFINITY, 0.1));
        types.add(new ParameterTypeCategory("adaption_type", "Use this adaption type for additional peaks.", SinusFactory.ADAPTION_TYPES, 2));
        return types;
    }
}

