/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;
import java.util.List;

public class RemoveUselessAttributes
extends IndividualOperator {
    public List operate(AttributeWeightedExampleSet exampleSet) throws Exception {
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        clone.recalculateAllAttributeStatistics();
        for (int i = clone.getNumberOfAttributes() - 1; i >= 0; --i) {
            Attribute attribute = clone.getAttribute(i);
            double weight = clone.getWeight(attribute);
            if (weight == 0.0) {
                clone.removeAttribute(attribute);
                continue;
            }
            if (attribute.getMinimum() != attribute.getMaximum() || attribute.getMinimum() != 0.0 && attribute.getMinimum() != 1.0) continue;
            clone.removeAttribute(attribute);
        }
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        if (clone.getNumberOfUsedAttributes() > 0) {
            l.add(clone);
        } else {
            LogService.logMessage("No attributes left after removing useless attributes! Using original example set.", 4);
            l.add(exampleSet);
        }
        return l;
    }
}

