/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.FeatureOperator;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

public class BruteForceOperator
extends FeatureOperator {
    private List emptyList = new LinkedList();
    private List postOps = new LinkedList();

    public BruteForceOperator(OperatorDescription description) {
        super(description);
    }

    public Population createInitialPopulation(ExampleSet es) {
        AttributeWeightedExampleSet exampleSet = new AttributeWeightedExampleSet(es);
        for (int i = 0; i < es.getNumberOfAttributes(); ++i) {
            exampleSet.setAttributeUsed(i, false);
        }
        Population pop = new Population();
        this.addAll(pop, exampleSet, 0);
        return pop;
    }

    private void addAll(Population pop, AttributeWeightedExampleSet es, int startIndex) {
        if (startIndex >= es.getNumberOfAttributes()) {
            return;
        }
        Attribute attribute = es.getAttribute(startIndex);
        int endIndex = Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getBlockType(), 1) ? es.getBlockEndIndex(startIndex) : startIndex;
        AttributeWeightedExampleSet ce2 = (AttributeWeightedExampleSet)es.clone();
        for (int i = startIndex; i <= endIndex; ++i) {
            ce2.setAttributeUsed(i, false);
        }
        this.addAll(pop, ce2, endIndex + 1);
        AttributeWeightedExampleSet ce1 = (AttributeWeightedExampleSet)es.clone();
        for (int i = startIndex; i <= endIndex; ++i) {
            ce1.setAttributeUsed(i, true);
        }
        if (ce1.getNumberOfUsedAttributes() > 0) {
            pop.add(ce1);
        }
        this.addAll(pop, ce1, endIndex + 1);
    }

    public List getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return this.emptyList;
    }

    public List getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return this.postOps;
    }

    public boolean solutionGoodEnough(Population pop) {
        return true;
    }
}

