/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.NoBugError;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.Tools;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class UserError
extends OperatorException
implements NoBugError {
    private static ResourceBundle messages = null;
    private static final MessageFormat formatter = new MessageFormat("");
    private int code;
    private Operator operator;

    public UserError(Operator operator, Throwable cause, int code, Object[] arguments) {
        super(UserError.getErrorMessage(code, arguments), cause);
        Experiment experiment;
        this.code = code;
        this.operator = operator != null ? operator : ((experiment = Yale.getExperiment()) != null ? experiment.getCurrentOperator() : null);
    }

    public UserError(Operator operator, Throwable cause, int code) {
        this(operator, code, new Object[0], (Object)cause);
    }

    public UserError(Operator operator, int code, Object[] arguments) {
        this(operator, (Throwable)null, code, arguments);
    }

    public UserError(Operator operator, int code) {
        this(operator, (Throwable)null, code, new Object[0]);
    }

    public UserError(Operator operator, int code, Object argument1) {
        this(operator, (Throwable)null, code, new Object[]{argument1});
    }

    public UserError(Operator operator, Throwable cause, int code, Object argument1) {
        this(operator, cause, code, new Object[]{argument1});
    }

    public UserError(Operator operator, int code, Object argument1, Object argument2) {
        this(operator, (Throwable)null, code, new Object[]{argument1, argument2});
    }

    public String getDetails() {
        return UserError.getResourceString(this.code, "long", "Description missing.");
    }

    public String getErrorName() {
        return UserError.getResourceString(this.code, "name", "Unnamed error.");
    }

    public int getCode() {
        return this.code;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public static String getErrorMessage(int code, Object[] arguments) {
        String message = UserError.getResourceString(code, "short", "No message.");
        try {
            formatter.applyPattern(message);
            String formatted = formatter.format(arguments);
            return formatted;
        }
        catch (Throwable t) {
            return message;
        }
    }

    public static String getResourceString(int code, String key, String deflt) {
        if (messages == null) {
            return deflt;
        }
        try {
            return messages.getString("error." + code + "." + key);
        }
        catch (MissingResourceException e) {
            return deflt;
        }
    }

    public String getHTMLMessage() {
        return "<html>Error in: <b>" + this.getOperator() + "</b><br>" + Tools.escapeHTML(this.getMessage()) + "<hr>" + Tools.escapeHTML(this.getDetails()) + "</html>";
    }

    static {
        try {
            messages = ResourceBundle.getBundle("edu.udo.cs.yale.resources.UserErrorMessages");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

