/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public abstract class ResultObjectAdapter
implements ResultObject {
    private List actions = new LinkedList();

    public ResultObjectAdapter() {
        if (this instanceof Saveable) {
            this.addAction(new AbstractAction("Save..."){
                {
                    this.putValue("ShortDescription", "Save this " + Tools.classNameWOPackage(ResultObjectAdapter.this.getClass()) + " to disk.");
                }

                public void actionPerformed(ActionEvent e) {
                    File file = SwingTools.chooseFile(null, null, false);
                    try {
                        if (file != null) {
                            ((Saveable)((Object)ResultObjectAdapter.this)).save(file);
                        }
                    }
                    catch (Exception ex) {
                        SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
                    }
                }
            });
        }
    }

    public IOObject copy() {
        return this;
    }

    public String getName() {
        return Tools.classNameWOPackage(this.getClass());
    }

    protected void addAction(Action a) {
        this.actions.add(a);
    }

    public List getActions() {
        return this.actions;
    }

    public String toResultString() {
        return this.toString();
    }

    public Component getVisualisationComponent() {
        String str = ResultObjectAdapter.toHTML(this.toResultString());
        JLabel label = new JLabel("<html><h1>" + this.getName() + "</h1><pre>" + str + "</pre></html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }

    public static String toHTML(String string) {
        String str = string;
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\n", "<br>");
        return str;
    }
}

