/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

public class OperatorCreationException
extends Exception {
    public static final int INSTANTIATION_ERROR = 0;
    public static final int ILLEGAL_ACCESS_ERROR = 1;
    public static final int NO_CONSTRUCTOR_ERROR = 2;
    public static final int CONSTRUCTION_ERROR = 3;
    public static final int NO_DESCRIPTION_ERROR = 4;
    public static final int NO_UNIQUE_DESCRIPTION_ERROR = 5;

    public OperatorCreationException(int code, String className, Throwable cause) {
        super(OperatorCreationException.createMessage(code, className), cause);
    }

    private static String createMessage(int code, String className) {
        switch (code) {
            case 0: {
                return "Cannot instantiate '" + className + "'!";
            }
            case 1: {
                return "Cannot access '" + className + "'!";
            }
            case 2: {
                return "No one-argument constructor for operator descriptions: '" + className + "'!";
            }
            case 3: {
                return "Operator cannot be constructed: '" + className + "'!";
            }
            case 4: {
                return "No operator description object given for '" + className + "'!";
            }
            case 5: {
                return "No unique operator description object available for class '" + className + "'!";
            }
        }
        return "Error during operator creation of '" + className + "'!";
    }
}

