/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class IOContainer {
    private List ioObjects = new LinkedList();
    public static final IOContainer DUMMY_IO_CONTAINER = new IOContainer(new IOObject[]{new ResultObjectAdapter(){

        public String getName() {
            return "Dummy";
        }

        public String toString() {
            return "No intermediate results for this operator";
        }
    }});

    public IOContainer(Collection obj) {
        this.ioObjects.addAll(obj);
    }

    public IOContainer(IOObject[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            this.ioObjects.add(obj[i]);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("IOContainer (" + this.ioObjects.size() + " objects):\n");
        Iterator i = this.ioObjects.iterator();
        while (i.hasNext()) {
            IOObject current = (IOObject)i.next();
            result.append(current.toString() + "\n");
        }
        return result.toString();
    }

    public IOObject[] getIOObjects() {
        return this.ioObjects.toArray(new IOObject[this.ioObjects.size()]);
    }

    public IOObject get(Class cls) throws MissingIOObjectException {
        return this.getInput(cls, 0, false);
    }

    public IOObject get(Class cls, int nr) throws MissingIOObjectException {
        return this.getInput(cls, nr, false);
    }

    public IOObject remove(Class cls) throws MissingIOObjectException {
        return this.getInput(cls, 0, true);
    }

    public IOObject remove(Class cls, int nr) throws MissingIOObjectException {
        return this.getInput(cls, nr, true);
    }

    public boolean contains(Class cls) {
        try {
            this.getInput(cls, 0, false);
            return true;
        }
        catch (MissingIOObjectException e) {
            return false;
        }
    }

    private IOObject getInput(Class cls, int nr, boolean remove) throws MissingIOObjectException {
        int n = 0;
        ListIterator i = this.ioObjects.listIterator();
        while (i.hasNext()) {
            IOObject object = (IOObject)i.next();
            if (object == null || !cls.isAssignableFrom(object.getClass())) continue;
            if (n == nr) {
                if (remove) {
                    i.remove();
                }
                return object;
            }
            ++n;
        }
        throw new MissingIOObjectException(cls);
    }

    public IOContainer append(IOObject[] output) {
        LinkedList<IOObject> newObjects = new LinkedList<IOObject>();
        for (int i = 0; i < output.length; ++i) {
            newObjects.add(output[i]);
        }
        newObjects.addAll(this.ioObjects);
        return new IOContainer(newObjects);
    }

    public IOContainer prepend(IOObject[] output) {
        LinkedList<IOObject> newObjects = new LinkedList<IOObject>();
        newObjects.addAll(this.ioObjects);
        for (int i = 0; i < output.length; ++i) {
            newObjects.add(output[i]);
        }
        return new IOContainer(newObjects);
    }

    public IOContainer append(Collection output) {
        LinkedList newObjects = new LinkedList();
        newObjects.addAll(output);
        newObjects.addAll(this.ioObjects);
        return new IOContainer(newObjects);
    }

    public IOContainer copy() {
        LinkedList<IOObject> clones = new LinkedList<IOObject>();
        Iterator i = this.ioObjects.iterator();
        while (i.hasNext()) {
            clones.add(((IOObject)i.next()).copy());
        }
        return new IOContainer(clones);
    }
}

