/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.ExperimentListener;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.TempFileService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ExperimentOperator
extends OperatorChain {
    private List listenerList = new LinkedList();
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$ResultObject;

    public ExperimentOperator(OperatorDescription description) {
        super(description);
    }

    public ExperimentOperator(OperatorDescription description, Experiment experiment) {
        super(description);
        this.setExperiment(experiment);
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    public int getNumberOfSteps() {
        return this.getNumberOfChildrensSteps();
    }

    public void addExperimentListener(ExperimentListener l) {
        this.listenerList.add(l);
    }

    public void removeExperimentListener(ExperimentListener l) {
        this.listenerList.remove(l);
    }

    public void countStep() {
        super.countStep();
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            ((ExperimentListener)i.next()).experimentStep(this);
        }
    }

    public void experimentFinished() {
        super.experimentFinished();
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            ((ExperimentListener)i.next()).experimentEnded();
        }
    }

    public void sendEmail(IOContainer results, Throwable e) {
        String email = this.getParameterAsString("notification_email");
        if (email == null) {
            return;
        }
        LogService.logMessage("Sending notification email to '" + email + "'", 2);
        String name = email;
        int at = name.indexOf("@");
        if (at >= 0) {
            name = name.substring(0, at);
        }
        String subject = "Experiment " + this.getName() + " finished";
        String content = "Hello " + name + ",\n\n";
        content = content + "I'm sending you a notification message on your experiment '" + this.getName() + "'.\n";
        File logFile = LogService.getLogFile();
        if (logFile != null) {
            content = content + "Logfile is file://" + logFile.getAbsolutePath() + "\n\n";
        }
        if (e != null) {
            content = content + "Experiment failed: " + e.toString();
            subject = "Experiment " + this.getName() + " failed";
        }
        if (results != null) {
            ResultObject result;
            content = content + "\n\nResults:";
            int i = 0;
            do {
                try {
                    result = (ResultObject)results.get(class$edu$udo$cs$yale$operator$ResultObject == null ? ExperimentOperator.class$("edu.udo.cs.yale.operator.ResultObject") : class$edu$udo$cs$yale$operator$ResultObject, i);
                    content = content + "\n\n\n" + result.toResultString();
                    ++i;
                }
                catch (MissingIOObjectException exc) {
                    break;
                }
            } while (result != null);
        }
        Tools.sendEmail(email, subject, content);
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            Operator o = this.getOperator(i);
            if (!o.isEnabled()) continue;
            input = o.checkIO(input);
        }
        return this.getAllOutputClasses(input);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("logverbosity", "Log verbosity level.", LogService.LOG_VERBOSITY_NAMES, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile("logfile", "File to write logging information to.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile("resultfile", "File to write results to.", true));
        types.add(new ParameterTypeFile("temp_dir", "Directory for temp files.", true));
        types.add(new ParameterTypeCategory("delete_temp_files", "Keep all or none of the generated temporary files.", TempFileService.DELETE_TEMP_FILES, 1));
        String seedProperty = System.getProperty("yale.general.randomseed");
        int seed = Integer.parseInt(seedProperty);
        types.add(new ParameterTypeInt("random_seed", "Global random seed for random generators.", Integer.MIN_VALUE, Integer.MAX_VALUE, seed));
        types.add(new ParameterTypeString("notification_email", "Email address for the notification mail.", true));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Yale.registerYaleProperty(new ParameterTypeInt("yale.general.randomseed", "The default random seed (-1: random random seed).", 1, Integer.MAX_VALUE, 2001));
    }
}

