/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeValue;
import edu.udo.cs.yale.tools.LogService;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ExperimentLogOperator
extends Operator {
    private static final Class[] OUTPUT_CLASSES = new Class[0];
    private String[] valueNames;

    public ExperimentLogOperator(OperatorDescription description) {
        super(description);
    }

    private Object fetchValue(String name) {
        StringTokenizer reader = new StringTokenizer(name, ".");
        String type = reader.nextToken();
        if (type.equals("operator")) {
            String opName = reader.nextToken();
            Operator operator = this.getExperiment().getOperator(opName);
            if (operator != null) {
                type = reader.nextToken();
                if (type.equals("value")) {
                    String valueName = reader.nextToken();
                    double value = operator.getValue(valueName);
                    if (Double.isNaN(value)) {
                        LogService.logMessage(this.getName() + ": No such value in '" + name + "'", 4);
                        return null;
                    }
                    return new Double(value);
                }
                if (type.equals("parameter")) {
                    String parameterName = reader.nextToken();
                    Object value = operator.getParameter(parameterName);
                    if (value == null) {
                        LogService.logMessage(this.getName() + ": No such parameter in '" + name + "'", 4);
                        return null;
                    }
                    return value;
                }
                LogService.logMessage(this.getName() + ": Unknown token '" + type + "' in '" + name + "'", 4);
                return null;
            }
            LogService.logMessage(this.getName() + ": Unknown operator '" + opName + "' in '" + name + "'", 4);
            return null;
        }
        LogService.logMessage(this.getName() + ": Unknown token '" + type + "' in '" + name + "'", 4);
        return null;
    }

    public void experimentStarts() {
        List parameters = this.getParameterList("log");
        String[] columnNames = new String[parameters.size()];
        this.valueNames = new String[parameters.size()];
        Iterator i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object[] parameter = (Object[])i.next();
            columnNames[j] = (String)parameter[0];
            this.valueNames[j] = (String)parameter[1];
            ++j;
        }
        this.getExperiment().getStatistics(this.getName()).init(columnNames);
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public IOObject[] apply() {
        this.fetchAllValues();
        return new IOObject[0];
    }

    private void fetchAllValues() {
        Object[] row = new Object[this.valueNames.length];
        for (int i = 0; i < this.valueNames.length; ++i) {
            Object value;
            row[i] = value = this.fetchValue(this.valueNames[i]);
        }
        this.getExperiment().getStatistics(this.getName()).add(row);
    }

    public void experimentFinished() {
        super.experimentFinished();
        String filename = this.getParameterAsString("filename");
        if (filename != null) {
            LogService.logMessage(this.getName() + ": writing data to '" + filename + "'", 3);
            try {
                PrintWriter out = new PrintWriter(new FileWriter(this.getExperiment().resolveFileName(filename)));
                this.getExperiment().getStatistics(this.getName()).write(out);
                out.close();
            }
            catch (IOException e) {
                LogService.logMessage(this.getName() + ": Could not write to file [" + filename + "]", 6);
            }
        }
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile("filename", "File to save the data to.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList("log", "List of key value pairs where the key is the column name and the value specifies the experiment value to log.", new ParameterTypeValue("column_name", "operator.OPERATORNAME.[value|parameter].VALUE_NAME"));
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

