/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.ExperimentEditor;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class XMLEditor
extends JPanel
implements ExperimentEditor {
    private static final int HIGHLIGHT_MAIN = 0;
    private static final int HIGHLIGHT_OTHERS = 1;
    private static final int HIGHLIGHT_QUOTES = 2;
    private JTextPane editor;
    private MainFrame mainFrame;

    public XMLEditor(MainFrame mainFrame) {
        super(new BorderLayout());
        this.mainFrame = mainFrame;
        this.editor = new JTextPane();
        this.editor.setEditable(true);
        this.add((Component)new JScrollPane(this.editor), "Center");
    }

    public void setOperator(Operator root) {
        try {
            this.updateText(root.getXML(""));
        }
        catch (BadLocationException e) {
            SwingTools.showSimpleErrorMessage("Error during XML parsing: ", e);
        }
    }

    public void updateText(String text) throws BadLocationException {
        StyledDocument doc = this.editor.getStyledDocument();
        doc.remove(0, doc.getLength());
        SortedSet keywords = this.parseText(text);
        Iterator i = keywords.iterator();
        int endIndex = 0;
        while (i.hasNext()) {
            Keyword keyword = (Keyword)i.next();
            doc.insertString(doc.getLength(), text.substring(endIndex, keyword.getStart()), null);
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(attributeSet, keyword.getColor());
            doc.insertString(doc.getLength(), keyword.getKeyword(), attributeSet);
            endIndex = keyword.getStart() + keyword.getLength();
        }
        if (text.length() > endIndex) {
            doc.insertString(doc.getLength(), text.substring(endIndex, text.length()), null);
        }
    }

    private SortedSet parseText(String text) {
        TreeSet keywords = new TreeSet();
        this.searchQuotes(text, keywords);
        this.searchKeyword(text, "<operator", 1, 0, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "</operator>", 2, 1, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "<parameter", 1, 0, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "</parameter>", 2, 1, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "<description", 1, 0, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "<list", 1, 0, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "</list>", 2, 1, keywords, this.getHighlightingColor(0));
        this.searchKeyword(text, "name=", 0, 1, keywords, this.getHighlightingColor(1));
        this.searchKeyword(text, "class=", 0, 1, keywords, this.getHighlightingColor(1));
        this.searchKeyword(text, "value=", 0, 1, keywords, this.getHighlightingColor(1));
        this.searchKeyword(text, "key=", 0, 1, keywords, this.getHighlightingColor(1));
        this.searchKeyword(text, "breakpoints=", 0, 1, keywords, this.getHighlightingColor(1));
        this.searchKeyword(text, "activated=", 0, 1, keywords, this.getHighlightingColor(1));
        this.searchKeyword(text, "text=", 0, 1, keywords, this.getHighlightingColor(1));
        return keywords;
    }

    private Color getHighlightingColor(int type) {
        String propertyName = null;
        switch (type) {
            case 0: {
                propertyName = "yale.gui.xml.highlight.main";
                break;
            }
            case 1: {
                propertyName = "yale.gui.xml.highlight.other";
                break;
            }
            default: {
                propertyName = "yale.gui.xml.highlight.quote";
            }
        }
        String propertyString = System.getProperty(propertyName);
        String[] colors = propertyString.split(",");
        Color color = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        return color;
    }

    private void searchQuotes(String text, SortedSet keywords) {
        int lastIndex = text.lastIndexOf("\"");
        if (lastIndex < 0) {
            return;
        }
        String firstPart = text.substring(0, lastIndex);
        int firstIndex = firstPart.lastIndexOf("\"");
        if (firstIndex < 0) {
            return;
        }
        String quote = text.substring(firstIndex, lastIndex + 1);
        keywords.add(new Keyword(quote, firstIndex, this.getHighlightingColor(2)));
        this.searchQuotes(text.substring(0, firstIndex), keywords);
    }

    private void searchKeyword(String text, String keyword, int startOffset, int endOffset, SortedSet keywords, Color color) {
        int index = text.lastIndexOf(keyword);
        if (index < 0) {
            return;
        }
        String keywordName = keyword.substring(startOffset, keyword.length() - endOffset);
        keywords.add(new Keyword(keywordName, index + startOffset, color));
        this.searchKeyword(text.substring(0, index), keyword, startOffset, endOffset, keywords, color);
    }

    public void experimentChanged(Operator op) {
        this.setOperator(op);
    }

    public Component getMainComponent() {
        return this.editor;
    }

    public void validateExperiment() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.editor.getText().getBytes());
        Experiment newExp = new Experiment(in);
        ((InputStream)in).close();
        if (!newExp.getRootOperator().getXML("").equals(Yale.getExperiment().getRootOperator().getXML(""))) {
            newExp.setExperimentFile(Yale.getExperiment().getExperimentFile());
            YaleGUI.getMainFrame().setExperiment(newExp);
            this.mainFrame.experimentChanged();
        }
    }

    private class Keyword
    implements Comparable {
        private String word;
        private int start;
        private Color color;

        public Keyword(String word, int start, Color color) {
            this.word = word;
            this.start = start;
            this.color = color;
        }

        public String getKeyword() {
            return this.word;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.word.length();
        }

        public Color getColor() {
            return this.color;
        }

        public int compareTo(Object o) {
            Keyword k = (Keyword)o;
            return this.start - k.start;
        }

        public String toString() {
            return this.word + "(" + this.start + "," + (this.start + this.word.length()) + ")";
        }
    }
}

