/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.SettingsTabs;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TotDDialog
extends JDialog {
    private JEditorPane text = new JEditorPane();
    private JScrollPane textScrollPane = new JScrollPane(this.text);
    private JCheckBox showTip = new JCheckBox("Show tips at start up");
    private List allTips = new ArrayList();

    public TotDDialog() {
        super(YaleGUI.getMainFrame(), "Tip of the Day", true);
        try {
            StringBuffer current = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(Tools.openResource("totd.txt")));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    String tip = current.toString();
                    if (tip.length() > 0) {
                        this.allTips.add(tip);
                    }
                    current = new StringBuffer();
                    continue;
                }
                current.append(line + " ");
            }
            in.close();
        }
        catch (IOException e) {
            this.text.setText("Cannot display tip of the day: " + e.getMessage());
        }
        this.getContentPane().setLayout(new BorderLayout());
        JLabel iconLabel = new JLabel(new ImageIcon(Tools.getResource("icons/icon_totd.gif")));
        iconLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.getContentPane().add((Component)iconLabel, "West");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        String tipProperty = System.getProperty("yale.gui.tip.show");
        if (tipProperty.equals("true")) {
            this.showTip.setSelected(true);
        } else {
            this.showTip.setSelected(false);
        }
        buttonPanel.add(this.showTip);
        JButton nextButton = new JButton("Next");
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TotDDialog.this.nextTip();
            }
        });
        buttonPanel.add(nextButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TotDDialog.this.closeDialog();
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.text.setEditable(false);
        this.text.setContentType("text/html");
        this.nextTip();
        this.getContentPane().add((Component)this.textScrollPane, "Center");
        this.setSize(500, 400);
        this.setLocationRelativeTo(YaleGUI.getMainFrame());
    }

    private void closeDialog() {
        boolean show = this.showTip.isSelected();
        System.setProperty("yale.gui.tip.show", show ? "true" : "false");
        SettingsTabs settings = new SettingsTabs();
        try {
            settings.save();
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage("Cannot write setting into file!", e);
        }
        this.dispose();
    }

    private void nextTip() {
        Random random = new Random();
        int nextTip = random.nextInt(this.allTips.size());
        String tip = (String)this.allTips.get(nextTip);
        String nextTipString = null;
        nextTipString = ++nextTip < 10 ? "00" + nextTip : (nextTip < 100 ? "0" + nextTip : "" + nextTip);
        this.text.setText("<h2>Tip " + nextTipString + "</h2>\n" + tip);
        this.text.getCaret().setDot(0);
        this.textScrollPane.getVerticalScrollBar().setValue(0);
    }
}

