/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.PropertyCellEditor;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypePassword;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class SimplePropertyCellEditor
extends DefaultCellEditor
implements PropertyCellEditor {
    private boolean useEditorAsRenderer = false;

    public SimplePropertyCellEditor(ParameterTypeCategory type) {
        super(new JComboBox<String>(type.getValues()));
        this.editorComponent.setToolTipText(type.getDescription());
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object x) {
                super.setValue(x);
                ((JComboBox)SimplePropertyCellEditor.this.editorComponent).setSelectedIndex((Integer)x);
            }

            public Object getCellEditorValue() {
                return new Integer(((JComboBox)SimplePropertyCellEditor.this.editorComponent).getSelectedIndex());
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public SimplePropertyCellEditor(ParameterTypeStringCategory type) {
        super(new JComboBox<String>(type.getValues()));
        this.editorComponent.setToolTipText(type.getDescription());
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
        ((JComboBox)this.editorComponent).removeItemListener(this.delegate);
        ((JComboBox)this.editorComponent).setEditable(true);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object x) {
                super.setValue(x);
                ((JComboBox)SimplePropertyCellEditor.this.editorComponent).setSelectedItem((String)x);
            }

            public Object getCellEditorValue() {
                String selected = (String)((JComboBox)SimplePropertyCellEditor.this.editorComponent).getSelectedItem();
                if (selected.trim().length() == 0) {
                    selected = null;
                }
                return selected;
            }
        };
        ((JComboBox)this.editorComponent).addItemListener(this.delegate);
    }

    public SimplePropertyCellEditor(ParameterTypeBoolean type) {
        super(new JCheckBox());
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        ((JCheckBox)this.editorComponent).setHorizontalAlignment(0);
        this.editorComponent.setBackground(UIManager.getColor("Table.cellBackground"));
        this.useEditorAsRenderer = true;
    }

    public SimplePropertyCellEditor(final ParameterTypeInt type) {
        super(new JTextField());
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        ((JTextField)this.editorComponent).removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    if (x instanceof Integer || x instanceof String) {
                        ((JTextField)SimplePropertyCellEditor.this.editorComponent).setText(x.toString());
                    } else {
                        throw new IllegalArgumentException("Illegal value class for integer parameter: " + x.getClass().getName());
                    }
                }
            }

            public Object getCellEditorValue() {
                try {
                    int i = Integer.parseInt(((JTextField)SimplePropertyCellEditor.this.editorComponent).getText());
                    if ((double)i < type.getMinValue()) {
                        i = (int)type.getMinValue();
                    }
                    if ((double)i > type.getMaxValue()) {
                        i = (int)type.getMaxValue();
                    }
                    return new Integer(i);
                }
                catch (NumberFormatException e) {
                    return type.getDefaultValue();
                }
            }
        };
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
    }

    public SimplePropertyCellEditor(final ParameterTypeDouble type) {
        super(new JTextField());
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object x) {
                super.setValue(x);
                if (x != null) {
                    if (x instanceof Double || x instanceof String) {
                        ((JTextField)SimplePropertyCellEditor.this.editorComponent).setText(x.toString());
                    } else {
                        throw new IllegalArgumentException("Illegal value class for double parameter: " + x.getClass().getName());
                    }
                }
            }

            public Object getCellEditorValue() {
                try {
                    double d = Double.parseDouble(((JTextField)SimplePropertyCellEditor.this.editorComponent).getText());
                    if (d < type.getMinValue()) {
                        d = type.getMinValue();
                    }
                    if (d > type.getMaxValue()) {
                        d = type.getMaxValue();
                    }
                    return new Double(d);
                }
                catch (NumberFormatException e) {
                    return type.getDefaultValue();
                }
            }
        };
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
    }

    public SimplePropertyCellEditor(ParameterTypePassword type) {
        super(new JPasswordField());
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        this.useEditorAsRenderer = true;
    }

    public SimplePropertyCellEditor(final ParameterType type) {
        super(new JTextField());
        this.editorComponent.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public Object getCellEditorValue() {
                String text = ((JTextField)SimplePropertyCellEditor.this.editorComponent).getText();
                if (text == null || text.length() == 0) {
                    return type.getDefaultValue();
                }
                return text;
            }
        };
        ((JTextField)this.editorComponent).addActionListener(this.delegate);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return this.useEditorAsRenderer;
    }
}

