/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.gui.ColorPlotter;
import edu.udo.cs.yale.gui.Plotter;
import edu.udo.cs.yale.gui.YaleGUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SimplePlotterDialog
extends JDialog {
    private Plotter plotter;
    private Statistics statistics;

    public SimplePlotterDialog(Statistics statistics) {
        this(statistics, true);
    }

    public SimplePlotterDialog(Statistics statistics, boolean modal) {
        this(YaleGUI.getMainFrame(), statistics, -1, -1, modal);
    }

    public SimplePlotterDialog(Frame owner, Statistics statistics, int width, int height, boolean modal) {
        super(owner, statistics.getName(), modal);
        this.plotter = new ColorPlotter(statistics);
        this.statistics = statistics;
        this.getContentPane().add(this.plotter.getPlotter(), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimplePlotterDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        if (width < 0 || height < 0) {
            this.setSize(600, 400);
        } else {
            this.setSize(width, height);
        }
        this.setLocationRelativeTo(owner);
    }

    public void setDrawRange(double minX, double maxX, double minY, double maxY) {
        this.plotter.setDrawRange(minX, maxX, minY, maxY);
    }

    public void setXAxis(int index) {
        this.plotter.setAxis(0, index);
    }

    public void setYAxis(int index) {
        this.plotter.setAxis(1, index);
    }

    public void plotColumn(int index, boolean plot) {
        this.plotter.setPlotColumn(index, plot);
    }

    private void ok() {
        this.dispose();
    }
}

