/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.gui.ExperimentEditor;
import edu.udo.cs.yale.gui.PlotterPanel;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.ResultObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ResultDisplay
extends JPanel
implements ExperimentEditor {
    private int size;
    private List results;
    private JTabbedPane tabs = new JTabbedPane(4);
    private JLabel label = new JLabel("Results");
    private Collection statistics = new LinkedList();
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$ResultObject;

    public ResultDisplay() {
        super(new BorderLayout());
        this.add((Component)this.tabs, "Center");
        this.add((Component)this.label, "North");
        this.setData(null, "Results");
    }

    public void clear() {
        this.tabs.removeAll();
        this.setStatistics(new LinkedList());
        this.setData(null, null);
        this.repaint();
    }

    public void setStatistics(Collection statistics) {
        this.statistics = statistics;
        this.addStatistics();
    }

    private void addStatistics() {
        Iterator i = this.statistics.iterator();
        while (i.hasNext()) {
            Statistics stats = (Statistics)i.next();
            this.tabs.addTab(stats.getName(), new PlotterPanel(stats));
        }
    }

    public void setData(IOContainer results, String message) {
        int selectedIndex = this.tabs.getSelectedIndex();
        for (int i = this.tabs.getTabCount() - 1; i >= 0; --i) {
            Component c = this.tabs.getComponentAt(i);
            if (c instanceof PlotterPanel) continue;
            this.tabs.removeTabAt(i);
        }
        this.label.setText(message);
        this.results = ResultDisplay.convertToList(results);
        if (this.results.size() > 0) {
            Iterator i = this.results.iterator();
            while (i.hasNext()) {
                ResultObject result = (ResultObject)i.next();
                JPanel resultPanel = new JPanel(new BorderLayout());
                Component visualisationComponent = result.getVisualisationComponent();
                JScrollPane scrollPane = new JScrollPane(visualisationComponent);
                resultPanel.putClientProperty("main.component", visualisationComponent);
                resultPanel.add((Component)scrollPane, "Center");
                JPanel buttonPanel = new JPanel(new FlowLayout(2));
                Iterator action = result.getActions().iterator();
                while (action.hasNext()) {
                    buttonPanel.add(new JButton((Action)action.next()));
                }
                resultPanel.add((Component)buttonPanel, "South");
                this.tabs.addTab(result.getName(), resultPanel);
            }
        } else {
            this.label.setText("No results produced.");
        }
        if (selectedIndex < this.tabs.getTabCount()) {
            this.tabs.setSelectedIndex(selectedIndex);
        } else if (this.tabs.getTabCount() > 0) {
            this.tabs.setSelectedIndex(0);
        }
    }

    public static JDialog createDialog(IOContainer results, Component parent, List additionalButtons) {
        final JDialog dialog = new JDialog();
        dialog.setTitle("Experiment results");
        dialog.setModal(false);
        ResultDisplay display = new ResultDisplay();
        display.setData(results, "Results:");
        if (display.size != 0) {
            display.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            dialog.getContentPane().add((Component)display, "Center");
        } else {
            dialog.getContentPane().add((Component)new JLabel("No results produced."), "Center");
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        if (additionalButtons != null) {
            Iterator i = additionalButtons.iterator();
            while (i.hasNext()) {
                JButton button = (JButton)i.next();
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                });
                buttonPanel.add(button);
            }
        }
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        buttonPanel.add(close);
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    private static List convertToList(IOContainer container) {
        LinkedList<ResultObject> list = new LinkedList<ResultObject>();
        if (container != null) {
            ResultObject result = null;
            do {
                try {
                    result = (ResultObject)container.get(class$edu$udo$cs$yale$operator$ResultObject == null ? ResultDisplay.class$("edu.udo.cs.yale.operator.ResultObject") : class$edu$udo$cs$yale$operator$ResultObject, list.size());
                    list.add(result);
                }
                catch (MissingIOObjectException e) {
                    break;
                }
            } while (result != null);
        }
        return list;
    }

    public void experimentChanged(Operator operator) {
    }

    public void validateExperiment() throws Exception {
    }

    public Component getMainComponent() {
        JComponent c = (JComponent)this.tabs.getSelectedComponent();
        Component main = (Component)c.getClientProperty("main.component");
        if (main != null) {
            return main;
        }
        return c;
    }

    public void showSomething() {
        if (this.tabs.getSelectedIndex() == -1 && this.tabs.getTabCount() > 0) {
            this.tabs.setSelectedIndex(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

