/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.operator.Operator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public abstract class OperatorRenderer {
    public static final Font NAME_FONT = new Font("LucidaSans", 1, 12);
    public static final Font TYPE_FONT = new Font("LucidaSans", 0, 10);
    public static final int ICON_GAP = 4;

    public void drawName(Operator op, Graphics2D g) {
        Image icon = op.getOperatorDescription().getIcon();
        int x = 0;
        int y = 0;
        if (icon != null) {
            g.drawImage(icon, 0, 0, null);
            x += icon.getWidth(null) + 4;
        }
        g.setPaint(Color.black);
        g.setFont(NAME_FONT);
        Rectangle2D rect = NAME_FONT.getStringBounds(op.getName(), g.getFontRenderContext());
        g.drawString(op.getName(), (int)((double)x - rect.getX()), (int)((double)y - rect.getY()));
        y = (int)((double)y + rect.getHeight());
        g.setFont(TYPE_FONT);
        rect = TYPE_FONT.getStringBounds(op.getName(), g.getFontRenderContext());
        g.drawString(op.getOperatorDescription().getName(), (int)((double)x - rect.getX()), (int)((double)y - rect.getY()));
        y = (int)((double)y + rect.getHeight());
    }

    public Dimension getNameSize(Operator op, Graphics2D g) {
        Rectangle2D rect1 = NAME_FONT.getStringBounds(op.getName(), g.getFontRenderContext());
        Rectangle2D rect2 = TYPE_FONT.getStringBounds(op.getOperatorDescription().getName(), g.getFontRenderContext());
        double h = rect1.getHeight() + rect2.getHeight();
        double w = Math.max(rect1.getWidth(), rect2.getWidth());
        Image icon = op.getOperatorDescription().getIcon();
        if (icon != null) {
            h = Math.max((double)icon.getHeight(null), h);
            w += (double)(icon.getWidth(null) + 4);
        }
        return new Dimension((int)w, (int)h);
    }

    public abstract void drawOperator(Operator var1, Graphics2D var2);

    public abstract Dimension getSize(Operator var1, Graphics2D var2);
}

