/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.PropertyCellEditor;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NumberCellEditor
extends AbstractCellEditor
implements PropertyCellEditor {
    private JSpinner spinner;
    private ParameterTypeNumber type;

    public NumberCellEditor(ParameterTypeNumber type) {
        this.type = type;
        NumberTypeSpinnerModel model = null;
        if (type instanceof ParameterTypeInt) {
            ParameterTypeInt intType = (ParameterTypeInt)type;
            model = new NumberTypeSpinnerModel(intType.getMinValueInt(), intType.getMaxValueInt());
        } else {
            model = new NumberTypeSpinnerModel(type.getMinValue(), type.getMaxValue());
        }
        this.spinner = new JSpinner(model);
        this.spinner.setBorder(null);
        this.spinner.setToolTipText(type.getDescription() + " (" + type.getRange() + ")");
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                NumberCellEditor.this.fireEditingStopped();
            }
        });
        ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField().setHorizontalAlignment(2);
    }

    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.spinner.setValue(value);
        return this.spinner;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean useEditorAsRenderer() {
        return true;
    }

    private class NumberTypeSpinnerModel
    extends SpinnerNumberModel {
        private NumberTypeSpinnerModel(int min, int max) {
            super(min, min, max, 1);
            this.setValue(NumberCellEditor.this.type.getDefaultValue());
        }

        private NumberTypeSpinnerModel(double min, double max) {
            super(min, min, max, max - min < 10.0 ? (max - min) / 10.0 : 1.0);
            this.setValue(NumberCellEditor.this.type.getDefaultValue());
        }
    }
}

