/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.DataControl;
import edu.udo.cs.yale.gui.DataControlListener;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataViewer
extends JPanel
implements DataControlListener {
    private ExampleSet exampleSet;
    private JLabel dataLabel = new JLabel();

    public DataViewer(ExampleSet exampleSet) {
        super(new BorderLayout());
        this.exampleSet = exampleSet;
        DataControl control = new DataControl(exampleSet.getSize(), exampleSet.getNumberOfAttributes(), "Example", "Attribute");
        control.addViewChangeListener(this);
        this.add((Component)control, "West");
        this.add((Component)this.dataLabel, "Center");
        control.update();
    }

    public void update(int firstRow, int lastRow, int firstColumn, int lastColumn, int fractionDigits) {
        this.remove(this.dataLabel);
        this.dataLabel = new JLabel("<html>" + this.dataToHTML(firstRow, lastRow, firstColumn, lastColumn, fractionDigits) + "</html>");
        this.dataLabel.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        this.dataLabel.setFont(this.dataLabel.getFont().deriveFont(0));
        this.add((Component)this.dataLabel, "Center");
        this.validate();
    }

    private String dataToHTML(int firstRow, int lastRow, int firstAttribute, int lastAttribute, int fractionDigits) {
        StringBuffer buffer = new StringBuffer("");
        buffer.append("<h2>" + Tools.classNameWOPackage(this.exampleSet.getClass()) + "</h2>");
        buffer.append("<table bgcolor=\"#E3D8C3\" border=\"1\">");
        buffer.append("<tr bgcolor=\"#ccccff\">");
        for (int i = 0; i < this.exampleSet.getNumberOfAttributes(); ++i) {
            if (i < firstAttribute - 1) continue;
            buffer.append("<th>" + this.exampleSet.getAttribute(i).getName() + "</th>");
            if (i >= lastAttribute - 1) break;
        }
        Iterator s = this.exampleSet.getSpecialAttributeNames().iterator();
        while (s.hasNext()) {
            String name = (String)s.next();
            buffer.append("<th>" + name + "</th>");
        }
        buffer.append("</tr>");
        int counter = 0;
        ExampleReader reader = this.exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            if (++counter < firstRow) continue;
            buffer.append("<tr>");
            for (int i = 0; i < example.getNumberOfAttributes(); ++i) {
                if (i < firstAttribute - 1) continue;
                buffer.append("<td>" + example.getValueAsString(example.getAttribute(i), fractionDigits) + "</td>");
                if (i >= lastAttribute - 1) break;
            }
            s = this.exampleSet.getSpecialAttributeNames().iterator();
            while (s.hasNext()) {
                buffer.append("<td>" + example.getValueAsString(this.exampleSet.getAttribute((String)s.next()), fractionDigits) + "</td>");
            }
            buffer.append("</tr>");
            if (counter < lastRow) continue;
            break;
        }
        buffer.append("</table>");
        return buffer.toString();
    }
}

