/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.StatisticsRow;
import edu.udo.cs.yale.gui.Plotter;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ColorPlotter
extends JPanel
implements Plotter {
    private static Icon[] LINE_STYLE_ICONS;
    private static final Color[] LINE_COLORS;
    private static final Stroke[] LINE_STROKES;
    public static final LineStyle[] LINE_STYLES;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static final int[] TICS;
    private static final Font LABEL_FONT;
    private static final Color GRID_COLOR;
    private static final int MARGIN = 20;
    private static final int LABEL_MARGIN_X = 15;
    private static final int LABEL_MARGIN_Y = 50;
    private Statistics statistics;
    private List plots = new LinkedList();
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minColor;
    private double maxColor;
    private double xTicSize;
    private double yTicSize;
    private double drawMinX = Double.NEGATIVE_INFINITY;
    private double drawMaxX = Double.POSITIVE_INFINITY;
    private double drawMinY = Double.NEGATIVE_INFINITY;
    private double drawMaxY = Double.POSITIVE_INFINITY;
    private int[] axis = new int[]{-1, -1};
    private boolean[] columns;
    private int drawAmount = 100;
    private String currentToolTip = null;
    private double toolTipX = 0.0;
    private double toolTipY = 0.0;
    private int dragX;
    private int dragY;
    private int dragWidth;
    private int dragHeight;
    private boolean drawAxes = true;
    private boolean drawLabel = true;
    private AffineTransform transform;

    public ColorPlotter() {
        this.setBackground(Color.white);
    }

    public ColorPlotter(Statistics statistics) {
        this();
        this.setStatistics(statistics);
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
        statistics.addStatisticsListener(this);
        this.columns = new boolean[statistics.getNumberOfColumns()];
    }

    public Component getPlotter() {
        return this;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
        }
        return "none";
    }

    public int getValuePlotSelectionType() {
        return 1;
    }

    public Icon getIcon(int index) {
        return LINE_STYLE_ICONS[index % LINE_STYLE_ICONS.length];
    }

    public void statisticsUpdated(Statistics source) {
        this.repaint();
    }

    public boolean isSaveable() {
        return true;
    }

    public void save() {
        JFileChooser chooser = SwingTools.createFileChooser(null, false, new FileFilter[0]);
        if (chooser.showSaveDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.statistics.write(out);
                out.close();
            }
            catch (Exception ex) {
                SwingTools.showErrorMessage("Cannot write to file '" + file + "'", ex);
            }
        }
    }

    public int getNumberOfAxes() {
        return this.axis.length;
    }

    public void setAxis(int index, int dimension) {
        if (this.axis[index] != dimension) {
            this.axis[index] = dimension;
        }
        this.repaint();
    }

    public int getAxis(int index) {
        return this.axis[index];
    }

    public boolean canHandleDrawAmount() {
        return true;
    }

    public void setDrawAmount(int amount) {
        this.drawAmount = amount;
        this.repaint();
    }

    public void clearPlotColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = false;
        }
    }

    public void setPlotColumn(int index, boolean plot) {
        if (this.columns[index] != plot) {
            this.columns[index] = plot;
        }
        this.repaint();
    }

    public boolean getPlotColumn(int index) {
        return this.columns[index];
    }

    public boolean hasOptionsDialog() {
        return false;
    }

    public void showOptionsDialog() {
    }

    public void setDrawRangeInPlotterSpace(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
        if (drawMinX == -1.0 || drawMaxX == -1.0 || drawMinY == -1.0 || drawMaxY == -1.0) {
            this.drawMinX = Double.NEGATIVE_INFINITY;
            this.drawMaxX = Double.POSITIVE_INFINITY;
            this.drawMinY = Double.NEGATIVE_INFINITY;
            this.drawMaxY = Double.POSITIVE_INFINITY;
        } else {
            try {
                Point2D minPoint = this.transform.inverseTransform(new Point2D.Double(drawMinX, drawMinY), null);
                Point2D maxPoint = this.transform.inverseTransform(new Point2D.Double(drawMaxX, drawMaxY), null);
                this.drawMinX = minPoint.getX();
                this.drawMaxX = maxPoint.getX();
                this.drawMaxY = minPoint.getY();
                this.drawMinY = maxPoint.getY();
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
        this.repaint();
    }

    public Point2D getPositionInDataSpace(Point point) {
        Point2D p = null;
        if (this.transform != null) {
            try {
                p = this.transform.inverseTransform(point, null);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return p;
    }

    public void setDrawRange(double drawMinX, double drawMaxX, double drawMinY, double drawMaxY) {
        if (drawMinX == -1.0 || drawMaxX == -1.0 || drawMinY == -1.0 || drawMaxY == -1.0) {
            this.drawMinX = Double.NEGATIVE_INFINITY;
            this.drawMaxX = Double.POSITIVE_INFINITY;
            this.drawMinY = Double.NEGATIVE_INFINITY;
            this.drawMaxY = Double.POSITIVE_INFINITY;
        } else {
            this.drawMinX = drawMinX;
            this.drawMaxX = drawMaxX;
            this.drawMinY = drawMinY;
            this.drawMaxY = drawMaxY;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData() {
        this.plots.clear();
        this.maxColor = Double.NEGATIVE_INFINITY;
        this.maxY = Double.NEGATIVE_INFINITY;
        this.maxX = Double.NEGATIVE_INFINITY;
        this.minColor = Double.POSITIVE_INFINITY;
        this.minY = Double.POSITIVE_INFINITY;
        this.minX = Double.POSITIVE_INFINITY;
        if (this.axis[0] < 0) {
            return;
        }
        for (int column = 0; column < this.columns.length; ++column) {
            if (!this.columns[column]) continue;
            Plot points = new Plot(column);
            int drawEachPoint = 101 - this.drawAmount;
            Statistics statistics = this.statistics;
            synchronized (statistics) {
                Iterator i = this.statistics.iterator();
                int pointNumber = 0;
                while (i.hasNext()) {
                    StatisticsRow statRow = (StatisticsRow)i.next();
                    Object[] row = statRow.getRow();
                    if (pointNumber++ % drawEachPoint != 0) continue;
                    double x = Double.NaN;
                    double y = Double.NaN;
                    try {
                        PlotterPoint currentPoint;
                        if (row[column] == null || row[this.axis[0]] == null) continue;
                        x = Double.parseDouble(row[this.axis[0]].toString());
                        double color = Double.NaN;
                        y = this.axis[1] != -1 ? Double.parseDouble(row[this.axis[1]].toString()) : Double.parseDouble(row[column].toString());
                        if (column != -1) {
                            color = Double.parseDouble(row[column].toString());
                            this.minColor = Math.min(this.minColor, color);
                            this.maxColor = Math.max(this.maxColor, color);
                        }
                        if (!(currentPoint = new PlotterPoint(statRow.getId(), x, y, color)).isIn(this.drawMinX, this.drawMaxX, this.drawMinY, this.drawMaxY)) continue;
                        points.add(currentPoint);
                        this.minX = Math.min(x, this.minX);
                        this.maxX = Math.max(x, this.maxX);
                        this.minY = Math.min(y, this.minY);
                        this.maxY = Math.max(y, this.maxY);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Not a numerical data column: " + column);
                    }
                }
                this.plots.add(points);
                continue;
            }
        }
        if (!Double.isInfinite(this.drawMinX)) {
            this.minX = this.drawMinX;
        }
        if (!Double.isInfinite(this.drawMaxX)) {
            this.minX = this.drawMaxX;
        }
        if (!Double.isInfinite(this.drawMinY)) {
            this.minX = this.drawMinX;
        }
        if (!Double.isInfinite(this.drawMaxY)) {
            this.minX = this.drawMinX;
        }
        if (this.statistics.getNumberOfRows() == 0) {
            this.minY = 0.0;
            this.minX = 0.0;
            this.maxY = 1.0;
            this.maxX = 1.0;
        }
        if (this.minX == this.maxX) {
            this.minX -= 0.5;
            this.maxX += 0.5;
        }
        if (this.minY == this.maxY) {
            this.minY -= 0.5;
            this.maxY += 0.5;
        }
        this.xTicSize = this.getTicSize(this.minX, this.maxX);
        this.yTicSize = this.getTicSize(this.minY, this.maxY);
        this.minX = Math.floor(this.minX / this.xTicSize) * this.xTicSize;
        this.maxX = Math.ceil(this.maxX / this.xTicSize) * this.xTicSize;
        this.minY = Math.floor(this.minY / this.yTicSize) * this.yTicSize;
        this.maxY = Math.ceil(this.maxY / this.yTicSize) * this.yTicSize;
    }

    public void setDrawAxes(boolean drawAxes) {
        this.drawAxes = drawAxes;
        this.repaint();
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
        this.repaint();
    }

    public void setMousePosInDataSpace(int x, int y) {
        PlotterPoint point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            String id = point.getId();
            if (id != null) {
                this.setToolTip(id, point.getX(), point.getY());
            } else {
                this.setToolTip(null, 0.0, 0.0);
            }
        } else {
            this.setToolTip(null, 0.0, 0.0);
        }
    }

    public String getIdForPos(int x, int y) {
        PlotterPoint point = this.getPlotterPointForPos(x, y);
        if (point != null) {
            return point.getId();
        }
        return null;
    }

    private PlotterPoint getPlotterPointForPos(int x, int y) {
        Iterator i = this.plots.iterator();
        while (i.hasNext()) {
            SortedSet plot = (SortedSet)i.next();
            Iterator p = plot.iterator();
            while (p.hasNext()) {
                PlotterPoint current = (PlotterPoint)p.next();
                if (!current.contains(x, y)) continue;
                return current;
            }
        }
        return null;
    }

    public void setDragBounds(int dragX, int dragY, int dragWidth, int dragHeight) {
        this.dragX = dragX;
        this.dragY = dragY;
        this.dragWidth = dragWidth;
        this.dragHeight = dragHeight;
        this.repaint();
    }

    private void setToolTip(String toolTip, double x, double y) {
        this.currentToolTip = toolTip;
        this.toolTipX = x;
        this.toolTipY = y;
        this.repaint();
    }

    private double getTicSize(double min, double max) {
        double delta = (max - min) / 5.0;
        double e = Math.floor(Math.log(delta) / Math.log(10.0));
        double factor = Math.pow(10.0, e);
        for (int i = TICS.length - 1; i >= 0; --i) {
            if (!((double)TICS[i] * factor <= delta)) continue;
            return (double)TICS[i] * factor;
        }
        return factor;
    }

    private void drawPoints(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.plots.size() == 0) {
            return;
        }
        int c = 0;
        Iterator p = this.plots.iterator();
        while (p.hasNext()) {
            Plot plot = (Plot)p.next();
            if (plot.size() <= 0) continue;
            plot.getLineStyle().set(g);
            GeneralPath path = new GeneralPath();
            Iterator i = plot.iterator();
            boolean first = true;
            while (i.hasNext()) {
                PlotterPoint plotterPoint = (PlotterPoint)i.next();
                float gSpaceX = (float)((plotterPoint.getX() + dx) * sx);
                float gSpaceY = (float)((plotterPoint.getY() + dy) * sy);
                if (first || this.axis[1] >= 0) {
                    path.moveTo(gSpaceX, gSpaceY);
                } else {
                    path.lineTo(gSpaceX, gSpaceY);
                }
                Ellipse2D.Double circle = new Ellipse2D.Double(gSpaceX - 2.0f, gSpaceY - 2.0f, 5.0, 5.0);
                if (this.axis[1] >= 0) {
                    double scaledColor = (plotterPoint.getColor() - this.minColor) / (this.maxColor - this.minColor);
                    Color pointColor = this.getPointColor(scaledColor);
                    g.setColor(pointColor);
                }
                g.fill(circle);
                first = false;
            }
            g.draw(path);
            c = (c + 1) % LINE_STYLES.length;
        }
    }

    private void drawToolTip(Graphics2D g, double dx, double dy, double sx, double sy) {
        if (this.currentToolTip != null) {
            g.setFont(LABEL_FONT);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(this.currentToolTip, g.getFontRenderContext());
            g.setColor(new Color(170, 150, 240, 210));
            Rectangle2D.Double bg = new Rectangle2D.Double((this.toolTipX + dx) * sx - stringBounds.getWidth() / 2.0 - 4.0, (this.toolTipY + dy) * sy + 3.0, stringBounds.getWidth() + 5.0, Math.abs(stringBounds.getHeight()) + 3.0);
            g.fill(bg);
            g.setColor(Color.black);
            g.draw(bg);
            g.drawString(this.currentToolTip, (float)((this.toolTipX + dx) * sx - stringBounds.getWidth() / 2.0) - 2.0f, (float)((this.toolTipY + dy) * sy) + 6.0f);
        }
    }

    private void drawGrid(Graphics2D g, double dx, double dy, double sx, double sy) {
        DecimalFormat format = new DecimalFormat("0.00E0");
        g.setFont(LABEL_FONT);
        g.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < 14; ++i) {
            double x = (double)i * this.xTicSize + this.minX;
            double y = (double)i * this.yTicSize + this.minY;
            g.setColor(GRID_COLOR);
            if (x <= this.maxX) {
                g.draw(new Line2D.Double((x + dx) * sx, (this.minY + dy) * sy, (x + dx) * sx, (this.maxY + dy) * sy));
            }
            if (y <= this.maxY) {
                g.draw(new Line2D.Double((this.minX + dx) * sx, (y + dy) * sy, (this.maxX + dx) * sx, (y + dy) * sy));
            }
            g.setColor(Color.black);
            if (!this.drawAxes) continue;
            String label = format.format(y) + " ";
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
            g.drawString(label, (float)((this.minX + dx) * sx - stringBounds.getWidth()), (float)((y + dy) * sy - stringBounds.getHeight() / 2.0 - stringBounds.getY()));
            label = format.format(x);
            stringBounds = LABEL_FONT.getStringBounds(label, g.getFontRenderContext());
            g.drawString(label, (float)((x + dx) * sx - stringBounds.getWidth() / 2.0), (float)((this.minY + dy) * sy + stringBounds.getHeight()));
        }
    }

    private void draw(Graphics2D g, int pixWidth, int pixHeight) {
        double sx = 0.0;
        double sy = 0.0;
        if (this.drawAxes) {
            sx = ((double)pixWidth - 50.0) / (this.maxX - this.minX);
            sy = ((double)pixHeight - 15.0) / (this.maxY - this.minY);
        } else {
            sx = (double)pixWidth / (this.maxX - this.minX);
            sy = (double)pixHeight / (this.maxY - this.minY);
        }
        Graphics2D coordinateSpace = (Graphics2D)g.create();
        if (this.drawAxes) {
            coordinateSpace.translate(50, 15);
        }
        if (Double.isNaN(sx) || Double.isNaN(sy)) {
            coordinateSpace.scale(1.0, -1.0);
            coordinateSpace.drawString("No data points available (yet).", 0, -20);
            coordinateSpace.drawString("Zooming out with a right click might help.", 0, 0);
        } else {
            if (this.drawAxes) {
                this.transform.translate(50.0, 15.0);
            }
            this.transform.scale(sx, sy);
            this.transform.translate(-this.minX, -this.minY);
            this.drawGrid(coordinateSpace, -this.minX, -this.minY, sx, sy);
            this.drawPoints(coordinateSpace, -this.minX, -this.minY, sx, sy);
            this.drawToolTip(coordinateSpace, -this.minX, -this.minY, sx, sy);
        }
        coordinateSpace.dispose();
    }

    private void drawDragRectangle(Graphics2D g) {
        if (this.dragX != -1 && this.dragY != -1 && this.dragWidth != -1 && this.dragHeight != -1) {
            g.setColor(Color.gray);
            Rectangle2D.Double dragBounds = new Rectangle2D.Double(this.dragX, this.dragY, this.dragWidth, this.dragHeight);
            g.draw(dragBounds);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paint2DPlots((Graphics2D)graphics);
    }

    public void paint2DPlots(Graphics2D g) {
        int pixWidth = this.getWidth() - 40;
        int pixHeight = this.getHeight() - 40;
        Graphics2D scaled = (Graphics2D)g.create();
        scaled.translate(20, 20);
        scaled.translate(0, pixHeight + 1);
        this.prepareData();
        if (this.plots.size() == 0) {
            scaled.drawString("No plots selected.", 0, 0);
        } else {
            scaled.scale(1.0, -1.0);
            g.setColor(Color.black);
            this.transform = new AffineTransform();
            this.transform.translate(20.0, 20.0);
            this.transform.translate(0.0, pixHeight + 1);
            this.transform.scale(1.0, -1.0);
            this.draw(scaled, pixWidth, pixHeight);
        }
        scaled.dispose();
        if (this.drawLabel && this.axis[0] >= 0) {
            String xAxisLabel = this.statistics.getColumnName(this.axis[0]);
            Rectangle2D stringBounds = LABEL_FONT.getStringBounds(xAxisLabel, g.getFontRenderContext());
            g.drawString(xAxisLabel, 20 + (int)((double)(pixWidth / 2) - stringBounds.getWidth() / 2.0), 20 + (int)((double)pixHeight + stringBounds.getY()) + 3);
        }
        if (!Double.isInfinite(this.minColor) && !Double.isInfinite(this.maxColor) && this.minColor != this.maxColor && this.plots.size() == 1 && this.axis[1] != -1) {
            String minColorString = Tools.formatNumber(this.minColor);
            String maxColorString = Tools.formatNumber(this.maxColor);
            Rectangle2D minStringBounds = LABEL_FONT.getStringBounds(minColorString, g.getFontRenderContext());
            Rectangle2D maxStringBounds = LABEL_FONT.getStringBounds(maxColorString, g.getFontRenderContext());
            int legendWidth = (int)(minStringBounds.getWidth() + 114.0 + maxStringBounds.getWidth());
            int keyX = 20 + (pixWidth / 2 - legendWidth / 2);
            int keyY = (int)(10.0 - minStringBounds.getHeight() / 2.0);
            g.setColor(Color.black);
            g.drawString(minColorString, keyX, keyY);
            keyX = (int)((double)keyX + (minStringBounds.getWidth() + 10.0));
            for (int i = 0; i < 100; ++i) {
                double scaledColor = (double)i / 100.0;
                Color lineColor = this.getPointColor(scaledColor);
                g.setColor(lineColor);
                g.drawLine(keyX, keyY, keyX, keyY - 10);
                ++keyX;
            }
            g.setColor(Color.black);
            Rectangle2D.Double frame = new Rectangle2D.Double(keyX - 101, keyY - 11, 101.0, 11.0);
            g.draw(frame);
            g.drawString(maxColorString, keyX += 4, keyY);
        }
        this.drawDragRectangle(g);
    }

    private Color getPointColor(double value) {
        return new Color(Color.HSBtoRGB((float)(0.68 * (1.0 - value)), 1.0f, 1.0f));
    }

    static {
        int i;
        LINE_COLORS = new Color[]{Color.black, Color.red, Color.blue, Color.orange, new Color(0, 200, 0), Color.pink, Color.yellow, Color.gray};
        LINE_STROKES = new Stroke[]{new BasicStroke()};
        LINE_STYLES = new LineStyle[LINE_COLORS.length * LINE_STROKES.length];
        for (i = 0; i < LINE_STROKES.length; ++i) {
            for (int j = 0; j < LINE_COLORS.length; ++j) {
                ColorPlotter.LINE_STYLES[i * ColorPlotter.LINE_COLORS.length + j] = new LineStyle(LINE_COLORS[j], LINE_STROKES[i]);
            }
        }
        LINE_STYLE_ICONS = new LineStyleIcon[LINE_STYLES.length];
        for (i = 0; i < LINE_STYLE_ICONS.length; ++i) {
            ColorPlotter.LINE_STYLE_ICONS[i] = new LineStyleIcon(i);
        }
        TICS = new int[]{1, 2, 5};
        LABEL_FONT = new Font("Lucida Sans", 0, 11).deriveFont(AffineTransform.getScaleInstance(1.0, -1.0));
        GRID_COLOR = Color.lightGray;
    }

    public class PlotterPoint
    implements Comparable {
        private String id = null;
        private double x;
        private double y;
        private double color;

        public PlotterPoint(String id, double x, double y, double color) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getColor() {
            return this.color;
        }

        public boolean contains(int x, int y) {
            Point2D point = ColorPlotter.this.transform.transform(new Point2D.Double(this.x, this.y), null);
            return Math.abs(point.getX() - (double)x) < 2.0 && Math.abs(point.getY() - (double)y) < 2.0;
        }

        public boolean isIn(double minX, double maxX, double minY, double maxY) {
            return this.x >= minX && this.x <= maxX && this.y >= minY && this.y <= maxY;
        }

        public boolean equals(Object o) {
            PlotterPoint p = (PlotterPoint)o;
            return this.x == p.x && this.y == p.y;
        }

        public int compareTo(Object o) {
            PlotterPoint p = (PlotterPoint)o;
            int xCompare = Double.compare(this.x, p.x);
            if (xCompare == 0) {
                return Double.compare(this.y, p.y);
            }
            return xCompare;
        }
    }

    private class Plot
    extends TreeSet {
        private int styleIndex;

        private Plot(int styleIndex) {
            this.styleIndex = styleIndex;
        }

        private LineStyle getLineStyle() {
            return LINE_STYLES[this.styleIndex % LINE_STYLES.length];
        }
    }

    private static class LineStyle {
        private Color color;
        private Stroke stroke;

        private LineStyle(Color color, Stroke stroke) {
            this.color = color;
            this.stroke = stroke;
        }

        public void set(Graphics2D g) {
            g.setColor(this.color);
            g.setStroke(this.stroke);
        }
    }

    private static class LineStyleIcon
    implements Icon {
        private int index;

        private LineStyleIcon(int index) {
            this.index = index;
        }

        public int getIconWidth() {
            return 26;
        }

        public int getIconHeight() {
            return 1;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            LINE_STYLES[this.index].set((Graphics2D)g);
            g.drawLine(x + 2, y, x + 26, y);
        }
    }
}

