/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Version;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JOptionPane;

public class CheckForUpdatesThread
extends Thread {
    private boolean showFailureDialog = false;
    private MainFrame mainFrame;

    public CheckForUpdatesThread(MainFrame mainFrame, boolean dialog) {
        this.mainFrame = mainFrame;
        this.showFailureDialog = dialog;
    }

    public void run() {
        String remoteVersion = null;
        try {
            URL url = new URL("http://www-ai.cs.uni-dortmund.de/SOFTWARE/YALE/version.txt");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            remoteVersion = in.readLine();
            if (remoteVersion.length() == 0 || !Character.isDigit(remoteVersion.charAt(0))) {
                throw new Exception("Not a version: " + remoteVersion);
            }
            in.close();
            YaleGUI.saveLastUpdateCheckDate();
        }
        catch (Exception e) {
            LogService.logMessage("Not able to check for updates. Maybe no internet connection.", 4);
        }
        if (remoteVersion != null && remoteVersion.compareTo(Version.getVersion()) > 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "New version of Yale is available:\n\n          Yale " + remoteVersion + "\n\nPlease check our website:\n          http://yale.cs.uni-dortmund.de", "New Yale version", 1);
        } else if (this.showFailureDialog) {
            JOptionPane.showMessageDialog(this.mainFrame, "No newer versions of Yale available!", "Yale is up to date", 1);
        }
    }
}

