/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.YaleLineReader;
import edu.udo.cs.yale.gui.DataControl;
import edu.udo.cs.yale.gui.DataControlListener;
import edu.udo.cs.yale.gui.EditorCellRenderer;
import edu.udo.cs.yale.gui.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AttributeEditor
extends JTable
implements MouseListener,
DataControlListener {
    public static final int LOAD_DATA = 0;
    public static final int LOAD_SERIES_DATA = 1;
    private static final int COLUMN_WIDTH = 120;
    protected Action REMOVE_COLUMN_ACTION = new RemoveColumnAction();
    protected Action REMOVE_ROW_ACTION = new RemoveRowAction();
    protected Action GUESS_TYPE_ACTION = new GuessTypeAction();
    private static final int NAME_ROW = 0;
    private static final int TYPE_ROW = 1;
    private static final int VALUE_TYPE_ROW = 2;
    private static final int BLOCK_TYPE_ROW = 3;
    private static final int BLOCK_NUMBER_ROW = 4;
    private static final int UNIT_ROW = 5;
    private static final int SEPARATOR_ROW = 6;
    private static final int NUM_OF_HEADER_ROWS = 7;
    private ArrayList[] cellEditors;
    private ArrayList[] cellRenderers;
    private TableCellRenderer dataRenderer = new DataCellRenderer();
    private ArrayList sourceList;
    private File file;
    private Operator exampleSource;
    private AttributeTableModel model;
    private int rowCount;
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private int fractionDigits;
    private Vector dataColumnVector;
    private DataControl dataControl;

    public AttributeEditor(Operator exampleSource, DataControl dataControl) {
        this.cellEditors = new ArrayList[7];
        this.cellRenderers = new ArrayList[7];
        for (int i = 0; i < 7; ++i) {
            this.cellEditors[i] = new ArrayList();
            this.cellRenderers[i] = new ArrayList();
        }
        this.sourceList = new ArrayList();
        this.rowCount = 0;
        this.firstRow = 1;
        this.lastRow = 10;
        this.firstColumn = 1;
        this.lastColumn = 10;
        this.fractionDigits = 3;
        this.dataColumnVector = new Vector();
        this.dataControl = dataControl;
        this.model = new AttributeTableModel();
        this.setModel(this.model);
        this.exampleSource = exampleSource;
        this.setRowHeight(this.getRowHeight() + 4);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.addMouseListener(this);
    }

    private AttributeDataSource getDataSource(int i) {
        return (AttributeDataSource)this.sourceList.get(i);
    }

    private String getDatum(int row, int column) {
        Vector col = (Vector)this.dataColumnVector.get(column);
        if (row >= col.size()) {
            return "?";
        }
        return (String)col.get(row);
    }

    private void setDatum(int row, int column, String value) {
        Vector col = (Vector)this.dataColumnVector.get(column);
        if (row >= col.size()) {
            col.addElement(value);
            if (row >= this.rowCount) {
                this.rowCount = row + 1;
            }
        } else {
            col.setElementAt(value, row);
        }
        this.dataControl.setMaxRows(Math.max(this.dataControl.getMaxRows(), col.size()));
        this.dataControl.setMaxColumns(Math.max(this.dataControl.getMaxColumns(), this.dataColumnVector.size()));
    }

    private int getDefaultMaximumNumber(String limitName, int defaultNumber) {
        String max = System.getProperty("yale.gui.attributeeditor." + limitName);
        if (max != null) {
            try {
                int number = Integer.parseInt(max);
                if (number == -1) {
                    return defaultNumber;
                }
                return number;
            }
            catch (NumberFormatException e) {
                LogService.logMessage("Value of yale.gui.attributeeditor." + limitName + " must be an integer!", 6);
                return defaultNumber;
            }
        }
        return defaultNumber;
    }

    private void createNewColumn() {
        JTextField nameField = new JTextField();
        nameField.setToolTipText("The name of the attribute.");
        this.cellEditors[0].add(new DefaultCellEditor(nameField));
        JComboBox<String> typeBox = new JComboBox<String>(AttributeDataSource.KNOWN_TYPES);
        typeBox.setEditable(true);
        typeBox.setToolTipText("The type of the attribute ('attribute' for regular learning attributes or a special attribute name).");
        this.cellEditors[1].add(new DefaultCellEditor(typeBox));
        String[] allValueTypes = Ontology.ATTRIBUTE_VALUE_TYPE.getNames();
        String[] valueTypes = new String[allValueTypes.length - 1];
        System.arraycopy(allValueTypes, 1, valueTypes, 0, valueTypes.length);
        JComboBox<String> valueTypeBox = new JComboBox<String>(valueTypes);
        valueTypeBox.setToolTipText("The value type of the attribute.");
        this.cellEditors[2].add(new DefaultCellEditor(valueTypeBox));
        JComboBox<String> blockTypeBox = new JComboBox<String>(Ontology.ATTRIBUTE_BLOCK_TYPE.getNames());
        blockTypeBox.setToolTipText("The block type of this attribute.");
        this.cellEditors[3].add(new DefaultCellEditor(blockTypeBox));
        JTextField blockNumberField = new JTextField();
        blockNumberField.setToolTipText("The block number for a series (must be -1 for single values).");
        this.cellEditors[4].add(new DefaultCellEditor(blockNumberField));
        JTextField unitField = new JTextField();
        unitField.setToolTipText("The unit definition for this attribute ('[unit]' or empty for no units).");
        this.cellEditors[5].add(new DefaultCellEditor(unitField));
        JTextField separator = new JTextField();
        separator.setToolTipText("Separates meta data from data.");
        separator.setEditable(false);
        this.cellEditors[6].add(new DefaultCellEditor(separator));
        for (int i = 0; i < this.cellRenderers.length; ++i) {
            this.cellRenderers[i].add(new EditorCellRenderer((TableCellEditor)this.cellEditors[i].get(this.cellEditors[i].size() - 1)));
        }
        this.dataColumnVector.add(new Vector());
    }

    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        TableColumn column = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1);
        column.setPreferredWidth(120);
    }

    private void addColumn(File file, int index, int valueType) {
        String name = file.getName() + " (" + (index + 1) + ")";
        AttributeDataSource source = new AttributeDataSource(AttributeFactory.createAttribute(name, valueType), file, index, "attribute");
        this.createNewColumn();
        this.sourceList.add(source);
    }

    protected void clear() {
        this.sourceList.clear();
        this.dataColumnVector.clear();
        this.rowCount = 0;
        this.dataControl.setMaxRows(0);
        this.dataControl.setMaxColumns(0);
        this.dataControl.update();
    }

    public void readData(File file, int dataType) throws IOException {
        String[] columns;
        int columnOffset = this.sourceList.size();
        int numberOfNewColumns = 0;
        int currentRow = -1;
        BufferedReader in = new BufferedReader(new FileReader(file));
        YaleLineReader reader = new YaleLineReader(this.exampleSource.getParameterAsString("column_separators"), this.exampleSource.getParameterAsString("comment_chars").toCharArray(), this.exampleSource.getParameterAsBoolean("use_quotes"));
        ArrayList<Integer> valueTypes = new ArrayList<Integer>();
        int expectedNumberOfColumns = -1;
        while ((columns = reader.readLine(in, expectedNumberOfColumns)) != null) {
            expectedNumberOfColumns = columns.length;
            ++currentRow;
            for (int currentColumn = 0; currentColumn < columns.length; ++currentColumn) {
                int valueType = 3;
                String value = columns[currentColumn];
                if (!value.equals("?") && value.length() > 0) {
                    try {
                        double d = Double.parseDouble(value);
                        valueType = d == (double)((int)d) ? 3 : 4;
                    }
                    catch (NumberFormatException e) {
                        valueType = 1;
                    }
                }
                if (currentColumn >= numberOfNewColumns) {
                    this.addColumn(file, currentColumn, valueType);
                    ++numberOfNewColumns;
                    valueTypes.add(new Integer(valueType));
                } else {
                    int soFar = (Integer)valueTypes.get(currentColumn);
                    if (soFar != valueType) {
                        if (soFar == 1 || valueType == 1) {
                            valueTypes.set(currentColumn, new Integer(1));
                        } else {
                            valueTypes.set(currentColumn, new Integer(4));
                        }
                    }
                }
                this.setDatum(currentRow, currentColumn + columnOffset, value);
            }
        }
        in.close();
        for (int i = 0; i < valueTypes.size(); ++i) {
            this.getDataSource(i + columnOffset).setAttribute(AttributeFactory.changeValueType(this.getDataSource(i + columnOffset).getAttribute(), (Integer)valueTypes.get(i)));
        }
        if (dataType == 1) {
            int nextFreeBlockNumber = AttributeFactory.getNextFreeBlockNumber();
            this.getDataSource(columnOffset).getAttribute().setBlockType(7);
            this.getDataSource(columnOffset).getAttribute().setBlockNumber(nextFreeBlockNumber);
            for (int i = 1; i < valueTypes.size() - 1; ++i) {
                this.getDataSource(i + columnOffset).getAttribute().setBlockType(1);
                this.getDataSource(i + columnOffset).getAttribute().setBlockNumber(nextFreeBlockNumber);
            }
            this.getDataSource(valueTypes.size() - 1 + columnOffset).getAttribute().setBlockType(8);
            this.getDataSource(valueTypes.size() - 1 + columnOffset).getAttribute().setBlockNumber(nextFreeBlockNumber);
        }
        this.update();
    }

    private void autoSetValueType(int column) {
        int valueType = 3;
        AttributeDataSource source = this.getDataSource(column);
        for (int i = 0; i < this.rowCount; ++i) {
            String value = this.getDatum(i, column);
            if (value == null || value.equals("?")) continue;
            try {
                double d = Double.parseDouble(value.toString());
                if (valueType != 3 || (double)((int)d) == d) continue;
                valueType = 4;
                continue;
            }
            catch (NumberFormatException e) {
                valueType = 1;
                break;
            }
        }
        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), valueType));
        this.model.fireTableCellUpdated(2, column);
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (row >= 7) {
            return super.getCellEditor(row, column);
        }
        return (TableCellEditor)this.cellEditors[row].get(column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row >= 7) {
            return this.dataRenderer;
        }
        return (TableCellRenderer)this.cellRenderers[row].get(column);
    }

    private boolean checkData(Object value, int row, int column) {
        return true;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            this.createPopupMenu(this.columnAtPoint(e.getPoint())).show(this, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu(int column) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.GUESS_TYPE_ACTION);
        menu.add(this.REMOVE_COLUMN_ACTION);
        menu.add(this.REMOVE_ROW_ACTION);
        return menu;
    }

    public void removeColumn(int column) {
        this.sourceList.remove(column);
        this.dataColumnVector.removeElementAt(column);
        this.rowCount = 0;
        Iterator i = this.dataColumnVector.iterator();
        while (i.hasNext()) {
            this.rowCount = Math.max(this.rowCount, ((List)i.next()).size());
        }
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.setMaxColumns(Math.max(0, this.dataControl.getMaxColumns() - 1));
        this.dataControl.update();
    }

    public void removeRow(int row) {
        if (this.rowCount == 0) {
            return;
        }
        Iterator i = this.dataColumnVector.iterator();
        while (i.hasNext()) {
            List c = (List)i.next();
            c.remove(row);
        }
        --this.rowCount;
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.update();
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<AttributeDataSource> columns = new LinkedList<AttributeDataSource>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator i = this.sourceList.iterator();
        int j = 0;
        while (i.hasNext()) {
            AttributeDataSource source = (AttributeDataSource)i.next();
            if (source.getType() != null && source.getType().equals(type)) {
                columns.add(source);
                columnNumbers.add(new Integer(j));
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            i = columns.iterator();
            j = 0;
            while (i.hasNext()) {
                names[j++] = ((AttributeDataSource)i.next()).getAttribute().getName();
            }
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, type + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                i = columns.iterator();
                Iterator k = columnNumbers.iterator();
                while (i.hasNext()) {
                    AttributeDataSource source = (AttributeDataSource)i.next();
                    Integer number = (Integer)k.next();
                    if (source.getAttribute().getName().equals(selection)) continue;
                    source.setType("attribute");
                    this.model.fireTableCellUpdated(1, number);
                }
            }
        }
    }

    public void writeXML(PrintWriter out) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        File defaultSource = this.getDataSource(0).getFile();
        out.println("<attributeset default_source=\"" + defaultSource.getAbsolutePath() + "\">");
        Iterator i = this.sourceList.iterator();
        int c = 0;
        while (i.hasNext()) {
            AttributeDataSource ads = (AttributeDataSource)i.next();
            Attribute attribute = ads.getAttribute();
            if (attribute.isNominal()) {
                for (int r = 0; r < this.rowCount; ++r) {
                    attribute.mapString(this.getDatum(r, c));
                }
            }
            ads.writeXML(out, defaultSource);
            ++c;
        }
        out.println("</attributeset>");
    }

    public void writeData(File file) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        PrintWriter out = new PrintWriter(new FileWriter(file));
        for (int i = 0; i < this.sourceList.size(); ++i) {
            AttributeDataSource source = (AttributeDataSource)this.sourceList.get(i);
            source.setSource(file, i);
        }
        for (int row = 0; row < this.rowCount; ++row) {
            for (int col = 0; col < this.sourceList.size(); ++col) {
                if (col != 0) {
                    out.print("\t");
                }
                out.print(this.getDatum(row, col));
            }
            out.println();
        }
        out.close();
    }

    public void openAttributeFile() {
        File file = SwingTools.chooseFile(this, null, true);
        if (file != null) {
            this.openAttributeFile(file);
        }
    }

    public void openAttributeFile(File file) {
        AttributeDataSources attributeDataSources = null;
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(file, true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not open '" + file + "':\n" + e, "Error", 0);
            return;
        }
        this.file = file;
        this.clear();
        FileDataRowReader reader = null;
        try {
            reader = new FileDataRowReader(new DataRowFactory(0), attributeDataSources.getDataSources(), -1, this.exampleSource.getParameterAsString("column_separators"), this.exampleSource.getParameterAsString("comment_chars").toCharArray(), this.exampleSource.getParameterAsBoolean("use_quotes"));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Cannot open data file: " + e, "Error", 0);
            return;
        }
        this.sourceList.addAll(attributeDataSources.getDataSources());
        for (int j = 0; j < attributeDataSources.getDataSources().size(); ++j) {
            this.createNewColumn();
        }
        MemoryExampleTable table = null;
        try {
            table = new MemoryExampleTable(new AttributeSet(attributeDataSources).getAllAttributes(), reader);
        }
        catch (UserError e) {
            SwingTools.showErrorMessage("Cannot load attribute descriptions.", e);
        }
        if (table != null) {
            ExampleReader e = table.createCompleteExampleSet(null, null, null, null).getExampleReader();
            this.rowCount = 0;
            while (e.hasNext()) {
                Example example = e.next();
                Iterator adsIterator = this.sourceList.iterator();
                int n = 0;
                while (adsIterator.hasNext()) {
                    AttributeDataSource ads = (AttributeDataSource)adsIterator.next();
                    this.setDatum(this.rowCount, n++, example.getValueAsString(ads.getAttribute()));
                }
                ++this.rowCount;
            }
        }
        this.update();
    }

    public void saveAttributeFile() {
        for (int i = 1; i < AttributeDataSource.KNOWN_TYPES.length; ++i) {
            this.ensureAttributeTypeIsUnique(AttributeDataSource.KNOWN_TYPES[i]);
        }
        File file = SwingTools.chooseFile(this, null, false);
        if (file != null) {
            this.file = file;
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                this.writeXML(out);
                out.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving attribute file " + file, 0);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    private void update() {
        this.dataControl.setFirstRow(1);
        this.dataControl.setLastRow(Math.min(this.dataControl.getMaxRows(), this.getDefaultMaximumNumber("rowlimit", this.dataControl.getMaxRows())));
        this.dataControl.setFirstColumn(1);
        this.dataControl.setLastColumn(Math.min(this.dataControl.getMaxColumns(), this.getDefaultMaximumNumber("columnlimit", this.dataControl.getMaxColumns())));
        this.dataControl.update();
    }

    public void update(int firstRow, int lastRow, int firstColumn, int lastColumn, int fractionDigits) {
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstColumn = firstColumn;
        this.lastColumn = lastColumn;
        this.fractionDigits = fractionDigits;
        this.model.fireTableStructureChanged();
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private AttributeTableModel() {
        }

        public int getColumnCount() {
            return Math.min(AttributeEditor.this.sourceList.size(), AttributeEditor.this.lastColumn - (AttributeEditor.this.firstColumn - 1));
        }

        public int getRowCount() {
            return Math.min(AttributeEditor.this.rowCount, AttributeEditor.this.lastRow - (AttributeEditor.this.firstRow - 1)) + 7;
        }

        public String getColumnName(int _column) {
            int column = _column + (AttributeEditor.this.firstColumn - 1);
            AttributeDataSource source = AttributeEditor.this.getDataSource(column);
            return source.getFile().getName() + " (" + (source.getColumn() + 1) + ")";
        }

        public Object getValueAt(int _row, int _column) {
            int row = _row + (AttributeEditor.this.firstRow - 1);
            int column = _column + (AttributeEditor.this.firstColumn - 1);
            if (row < 7) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 0: {
                        return source.getAttribute().getName();
                    }
                    case 1: {
                        return source.getType();
                    }
                    case 5: {
                        String unitString = source.getAttribute().unitToString();
                        if (unitString.length() == 0) {
                            return "[unit]";
                        }
                        return unitString;
                    }
                    case 2: {
                        return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(source.getAttribute().getValueType());
                    }
                    case 3: {
                        return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(source.getAttribute().getBlockType());
                    }
                    case 4: {
                        return source.getAttribute().getBlockNumber() + "";
                    }
                    case 6: {
                        return null;
                    }
                }
                return "This cannot happen!";
            }
            return AttributeEditor.this.getDatum(row - 7, column);
        }

        public void setValueAt(Object value, int row, int column) {
            if (row < 7) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 0: {
                        source.getAttribute().setName((String)value);
                        break;
                    }
                    case 1: {
                        source.setType((String)value);
                        break;
                    }
                    case 5: {
                        if (value.equals("[unit]")) break;
                        source.getAttribute().setUnits((String)value);
                        break;
                    }
                    case 2: {
                        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), Ontology.ATTRIBUTE_VALUE_TYPE.mapName((String)value)));
                        break;
                    }
                    case 3: {
                        source.getAttribute().setBlockType(Ontology.ATTRIBUTE_BLOCK_TYPE.mapName((String)value));
                        break;
                    }
                    case 4: {
                        source.getAttribute().setBlockNumber(Integer.valueOf((String)value));
                        break;
                    }
                }
            } else {
                AttributeEditor.this.setDatum(row - 7, column, (String)value);
            }
        }
    }

    private class GuessTypeAction
    extends AbstractAction {
        private int column = -1;

        private GuessTypeAction() {
            super("Guess value type", new ImageIcon(Tools.getResource("icons/icon_guess_column.gif")));
            this.putValue("ShortDescription", "Guess the value type of the current column based on the data.");
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent e) {
            int column = AttributeEditor.this.getSelectedColumn();
            if (column != -1) {
                AttributeEditor.this.autoSetValueType(column);
            }
        }
    }

    private class RemoveRowAction
    extends AbstractAction {
        private RemoveRowAction() {
            super("Remove row", new ImageIcon(Tools.getResource("icons/icon_delete_operator.gif")));
            this.putValue("ShortDescription", "Remove the current row");
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            int row = AttributeEditor.this.getSelectedRow() - 7;
            if (row != -1) {
                AttributeEditor.this.removeRow(row);
            }
        }
    }

    private class RemoveColumnAction
    extends AbstractAction {
        private RemoveColumnAction() {
            super("Remove column", new ImageIcon(Tools.getResource("icons/icon_delete_operator.gif")));
            this.putValue("ShortDescription", "Remove the current column");
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            int column = AttributeEditor.this.getSelectedColumn();
            if (column != -1) {
                AttributeEditor.this.removeColumn(column);
            }
        }
    }

    private class DataCellRenderer
    extends DefaultTableCellRenderer {
        private DataCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!AttributeEditor.this.checkData(value, row, column)) {
                c.setBackground(Color.red);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }
}

