/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.gui.InfoBox;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class AboutBox
extends JDialog {
    private static final Font ABOUT_TEXT_FONT = new Font("Lucida Sans", 0, 10);
    private Image[] logos;

    public AboutBox(Frame owner, String productName, String version, String aboutText, Image[] logos) {
        super(owner, "About " + productName, true);
        this.setResizable(false);
        this.logos = logos;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(new InfoBox(400, 64, 28, productName, 32, version, 32));
        JTextArea text = new JTextArea(aboutText, 13, 1);
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setBackground(this.getContentPane().getBackground());
        text.setFont(ABOUT_TEXT_FONT);
        text.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.getContentPane().add(text);
        this.getContentPane().add(new LogoDrawer());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutBox.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(closeButton);
        this.getContentPane().add(buttonPanel);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private class LogoDrawer
    extends JPanel {
        public LogoDrawer() {
            this.setPreferredSize(InfoBox.getLogoSize(AboutBox.this.logos));
        }

        public void paint(Graphics g) {
            InfoBox.drawLogos(g, AboutBox.this.logos);
        }
    }
}

