/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.AttributePeak;
import edu.udo.cs.yale.generator.BasicArithmeticOperationGenerator;
import edu.udo.cs.yale.generator.ConstantGenerator;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.TrigonometricFunctionGenerator;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.math.BinaryPeakFinder;
import edu.udo.cs.yale.tools.math.Complex;
import edu.udo.cs.yale.tools.math.FastFourierTransform;
import edu.udo.cs.yale.tools.math.Peak;
import edu.udo.cs.yale.tools.math.PeakFinder;
import edu.udo.cs.yale.tools.math.SpectrumFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SinusFactory {
    private static final double MIN_EVIDENCE = 0.2;
    public static final String[] ADAPTION_TYPES = new String[]{"uniformly", "uniformly_without_nu", "gaussian"};
    public static final int UNIFORMLY = 0;
    public static final int UNIFORMLY_WITHOUT_NU = 1;
    public static final int GAUSSIAN = 2;
    private int attributesPerPeak = 3;
    private double epsilon = 0.1;
    private int adaptionType = 0;
    private int maxPeaks = 5;
    private FastFourierTransform fft = null;
    private SpectrumFilter filter = null;
    private PeakFinder peakFinder = null;

    public SinusFactory(int maxPeaks) {
        this.maxPeaks = maxPeaks;
        this.fft = new FastFourierTransform(4);
        this.filter = new SpectrumFilter(0);
        this.peakFinder = new BinaryPeakFinder();
    }

    public void setAdaptionType(int type) {
        this.adaptionType = type;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setAttributePerPeak(int attributesPerPeak) {
        this.attributesPerPeak = attributesPerPeak;
    }

    public List getAttributePeaks(ExampleSet exampleSet, Attribute first, Attribute second) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        Complex[] result = this.fft.getFourierTransform(exampleSet, first, second);
        Peak[] spectrum = this.filter.filter(result, exampleSet.getSize());
        double average = 0.0;
        for (int k = 0; k < spectrum.length; ++k) {
            average += spectrum[k].getMagnitude();
        }
        average /= (double)spectrum.length;
        List peaks = this.peakFinder.getPeaks(spectrum);
        Collections.sort(peaks);
        double inputDeviation = Math.sqrt(second.getVariance()) / (second.getMaximum() - second.getMinimum());
        Iterator p = peaks.iterator();
        double maxEvidence = Double.NaN;
        LinkedList<AttributePeak> attributes = new LinkedList<AttributePeak>();
        for (int k = 0; k < this.maxPeaks; ++k) {
            if (!p.hasNext()) continue;
            Peak peak = (Peak)p.next();
            double evidence = peak.getMagnitude() / average * (1.0 / inputDeviation);
            if (Double.isNaN(maxEvidence)) {
                maxEvidence = evidence;
            }
            if (!(evidence > 0.2 * maxEvidence)) continue;
            attributes.add(new AttributePeak(second, peak.getIndex(), evidence));
        }
        return attributes;
    }

    public void generateSinusFunctions(ExampleSet exampleSet, List attributes) throws GenerationException {
        if (attributes.size() > 0) {
            Collections.sort(attributes);
            double totalMaxEvidence = ((AttributePeak)attributes.get(0)).getEvidence();
            Iterator a = attributes.iterator();
            while (a.hasNext()) {
                AttributePeak ae = (AttributePeak)a.next();
                if (!(ae.getEvidence() > 0.2 * totalMaxEvidence)) continue;
                for (int i = 0; i < this.attributesPerPeak; ++i) {
                    double frequency = ae.getFrequency();
                    switch (this.adaptionType) {
                        case 0: {
                            if (this.attributesPerPeak == 1) break;
                            frequency = (double)i / (double)(this.attributesPerPeak - 1) * 2.0 * this.epsilon * frequency + (frequency - this.epsilon * frequency);
                            break;
                        }
                        case 1: {
                            if (this.attributesPerPeak == 1) break;
                            frequency = (double)i / (double)(this.attributesPerPeak - 1) * 2.0 * this.epsilon + (frequency - this.epsilon);
                            break;
                        }
                        case 2: {
                            frequency = RandomGenerator.getGlobalRandomGenerator().nextGaussian() * this.epsilon + frequency;
                        }
                    }
                    List frequencyResult = this.generateAttribute(exampleSet, new ConstantGenerator(frequency));
                    BasicArithmeticOperationGenerator scale = new BasicArithmeticOperationGenerator(2);
                    scale.setArguments(new Attribute[]{(Attribute)frequencyResult.get(0), ae.getAttribute()});
                    List scaleResult = this.generateAttribute(exampleSet, scale);
                    TrigonometricFunctionGenerator sin = new TrigonometricFunctionGenerator(0);
                    sin.setArguments(new Attribute[]{(Attribute)scaleResult.get(0)});
                    List sinResult = this.generateAttribute(exampleSet, sin);
                    exampleSet.addAllAttributes(sinResult);
                }
            }
        }
    }

    private List generateAttribute(ExampleSet exampleSet, FeatureGenerator generator) throws GenerationException {
        LinkedList<FeatureGenerator> generators = new LinkedList<FeatureGenerator>();
        generators.add(generator);
        return FeatureGenerator.generateAll(exampleSet.getExampleTable(), generators);
    }
}

