/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.List;

public class Tools {
    public static void fillTableWithRandomValues(ExampleTable exampleTable) {
        RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
        DataRowReader reader = exampleTable.getDataReader();
        Attribute[] attributes = exampleTable.getAttributes();
        while (reader.hasNext()) {
            DataRow dataRow = reader.next();
            for (int i = 0; i < attributes.length; ++i) {
                if (attributes[i] == null) continue;
                if (attributes[i].isNumerical()) {
                    double min = attributes[i].getMinimum();
                    double max = attributes[i].getMaximum();
                    if (max > min) {
                        dataRow.set(attributes[i], random.nextDoubleInRange(min, max));
                        continue;
                    }
                    dataRow.set(attributes[i], random.nextDouble());
                    continue;
                }
                dataRow.set(attributes[i], 0.0);
            }
        }
    }

    public static Attribute[] createAttributeArray(ExampleSet exampleSet) {
        Attribute[] attributes = new Attribute[exampleSet.getNumberOfAttributes()];
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            attributes[i] = exampleSet.getAttribute(i);
        }
        return attributes;
    }

    public static Attribute[] getRandomCompatibleAttributes(ExampleSet exampleSet, FeatureGenerator generator, int maxDepth, String[] functions) {
        List inputAttributes = generator.getInputCandidates(exampleSet, maxDepth, functions);
        if (inputAttributes.size() > 0) {
            return (Attribute[])inputAttributes.get(RandomGenerator.getGlobalRandomGenerator().nextInt(inputAttributes.size()));
        }
        return null;
    }

    public static Attribute[] getWeightedCompatibleAttributes(AttributeWeightedExampleSet exampleSet, FeatureGenerator generator, int maxDepth, String[] functions) {
        List inputAttributes = generator.getInputCandidates(exampleSet, maxDepth, functions);
        double[] probs = new double[inputAttributes.size()];
        double probSum = 0.0;
        Iterator i = inputAttributes.iterator();
        int k = 0;
        while (i.hasNext()) {
            Attribute[] candidate = (Attribute[])i.next();
            for (int j = 0; j < candidate.length; ++j) {
                double weight = exampleSet.getWeight(candidate[j]);
                probSum += weight;
                probs[k] = weight;
            }
        }
        int j = 0;
        while (j < probs.length) {
            int n = j++;
            probs[n] = probs[n] / probSum;
        }
        RandomGenerator.getGlobalRandomGenerator();
        return (Attribute[])inputAttributes.get(RandomGenerator.randomIndex(probs));
    }

    public static double getAverageWeight(AttributeWeightedExampleSet exampleSet) {
        int counter = 0;
        double weightSum = 0.0;
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            double weight = exampleSet.getWeight(i);
            if (Double.isNaN(weight)) continue;
            weightSum += Math.abs(weight);
            ++counter;
        }
        return weightSum / (double)counter;
    }

    public static double[] getProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet) {
        return Tools.getProbabilitiesFromWeights(attributes, exampleSet, false);
    }

    public static double[] getInverseProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet) {
        return Tools.getProbabilitiesFromWeights(attributes, exampleSet, true);
    }

    public static double[] getProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet, boolean inverse) {
        double weightSum = 0.0;
        int counter = 0;
        for (int i = 0; i < attributes.length; ++i) {
            double weight = exampleSet.getWeight(attributes[i]);
            if (Double.isNaN(weight)) continue;
            weightSum += Math.abs(weight);
            ++counter;
        }
        double weightAverage = weightSum / (double)counter;
        weightSum += (double)(attributes.length - counter) * weightAverage;
        double[] probs = new double[attributes.length];
        for (int i = 0; i < probs.length; ++i) {
            double weight = exampleSet.getWeight(attributes[i]);
            probs[i] = Double.isNaN(weight) ? weightAverage / weightSum : (inverse ? (2.0 * weightAverage - Math.abs(weight)) / weightSum : Math.abs(weight) / weightSum);
        }
        return probs;
    }

    public static Attribute selectAttribute(Attribute[] attributes, double[] probs) {
        double r = RandomGenerator.getGlobalRandomGenerator().nextDouble();
        double sum = 0.0;
        for (int i = 0; i < attributes.length; ++i) {
            if (!(r < (sum += probs[i]))) continue;
            return attributes[i];
        }
        return attributes[attributes.length - 1];
    }
}

