/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleSetAdapter;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.PartitionBuilder;
import edu.udo.cs.yale.example.ShuffledPartitionBuilder;
import edu.udo.cs.yale.example.SimplePartitionBuilder;
import edu.udo.cs.yale.example.SplittedExampleSetReader;
import edu.udo.cs.yale.example.StratifiedPartitionBuilder;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;

public class SplittedExampleSet
extends ExampleSetAdapter {
    public static final String[] SAMPLING_NAMES = new String[]{"linear sampling", "shuffled sampling", "stratified sampling"};
    public static final int LINEAR_SAMPLING = 0;
    public static final int SHUFFLED_SAMPLING = 1;
    public static final int STRATIFIED_SAMPLING = 2;
    private Partition partition;

    public SplittedExampleSet(SplittedExampleSet exampleSet) {
        super(exampleSet);
        this.partition = (Partition)exampleSet.partition.clone();
    }

    public SplittedExampleSet(ExampleSet exampleSet, Partition partition) {
        super(exampleSet);
        this.partition = partition;
    }

    public SplittedExampleSet(ExampleSet exampleSet, double splitRatio) {
        this(exampleSet, splitRatio, 1);
    }

    public SplittedExampleSet(ExampleSet exampleSet, double splitRatio, int samplingType) {
        this(exampleSet, new double[]{splitRatio, 1.0 - splitRatio}, samplingType);
    }

    public SplittedExampleSet(ExampleSet exampleSet, double[] splitRatios, int samplingType) {
        this(exampleSet, new Partition(splitRatios, exampleSet.getSize(), SplittedExampleSet.createPartitionBuilder(exampleSet, samplingType)));
    }

    public SplittedExampleSet(ExampleSet exampleSet, int numberOfSubsets) {
        this(exampleSet, numberOfSubsets, 2);
    }

    public SplittedExampleSet(ExampleSet exampleSet, int numberOfSubsets, int samplingType) {
        this(exampleSet, new Partition(numberOfSubsets, exampleSet.getSize(), SplittedExampleSet.createPartitionBuilder(exampleSet, samplingType)));
    }

    private static PartitionBuilder createPartitionBuilder(ExampleSet exampleSet, int samplingType) {
        PartitionBuilder builder = null;
        switch (samplingType) {
            case 0: {
                builder = new SimplePartitionBuilder();
                break;
            }
            case 1: {
                builder = new ShuffledPartitionBuilder();
                break;
            }
            default: {
                if (exampleSet.getLabel() != null && exampleSet.getLabel().isNominal()) {
                    builder = new StratifiedPartitionBuilder(exampleSet);
                    break;
                }
                LogService.logMessage("Example set has no nominal label: using shuffled partition instead of stratified partition!", 4);
                builder = new ShuffledPartitionBuilder();
            }
        }
        return builder;
    }

    public void selectSingleSubset(int index) {
        this.partition.clearSelection();
        this.partition.selectSubset(index);
        this.clearUserData();
    }

    public void selectAllSubsetsBut(int index) {
        this.partition.clearSelection();
        for (int i = 0; i < this.partition.getNumberOfSubsets(); ++i) {
            if (i == index) continue;
            this.partition.selectSubset(i);
        }
        this.clearUserData();
    }

    public int getNumberOfSubsets() {
        return this.partition.getNumberOfSubsets();
    }

    public ExampleReader getExampleReader() {
        return new SplittedExampleSetReader(super.getExampleReader(), (Partition)this.partition.clone());
    }

    public int getSize() {
        return this.partition.getSelectionSize();
    }

    public Example getExample(int index) {
        int actualIndex = this.partition.mapIndex(index);
        return super.getExample(actualIndex);
    }

    public static SplittedExampleSet splitByAttribute(ExampleSet exampleSet, Attribute attribute) {
        int offset = 0;
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1)) {
            offset = 0;
        } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 3)) {
            offset = 0;
        } else {
            throw new RuntimeException("ExampleSet can only be splitted by a nominal or integer attribute!");
        }
        int[] elements = new int[exampleSet.getSize()];
        ExampleReader reader = exampleSet.getExampleReader();
        int i = 0;
        int maxNumber = 0;
        while (reader.hasNext()) {
            Example example = reader.next();
            int value = (int)example.getValue(attribute) - offset;
            maxNumber = Math.max(maxNumber, value);
            elements[i++] = value;
        }
        Partition partition = new Partition(elements, maxNumber + 1);
        return new SplittedExampleSet(exampleSet, partition);
    }
}

