/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.SparseDataRow;
import java.util.Arrays;

public class SparseArrayDataRow
implements DataRow,
SparseDataRow {
    private int[] x;
    private double[] values;
    private int counter = 0;

    public SparseArrayDataRow() {
        this(0);
    }

    public SparseArrayDataRow(int size) {
        this.x = new int[size];
        for (int i = 0; i < this.x.length; ++i) {
            this.x[i] = Integer.MAX_VALUE;
        }
        this.values = new double[size];
    }

    private void sort(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.x[j - 1] > this.x[j]; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        long v = this.x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && (long)this.x[b] <= v) {
                if ((long)this.x[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (long)this.x[c] >= v) {
                if ((long)this.x[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort(n - s, s);
        }
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.x[a] < this.x[b] ? (this.x[b] < this.x[c] ? b : (this.x[a] < this.x[c] ? c : a)) : (this.x[b] > this.x[c] ? b : (this.x[a] > this.x[c] ? c : a));
    }

    private void swap(int a, int b) {
        int t = this.x[a];
        this.x[a] = this.x[b];
        this.x[b] = t;
        double tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    public double get(Attribute attribute) {
        int val = attribute.getTableIndex();
        int index = Arrays.binarySearch(this.x, val);
        if (index < 0) {
            return attribute.isNominal() ? 0.0 : 0.0;
        }
        return this.values[index];
    }

    public void set(Attribute attribute, double value) {
        int index = attribute.getTableIndex();
        int index1 = Arrays.binarySearch(this.x, index);
        if (attribute.isDefault(value)) {
            if (index1 >= 0) {
                int[] y = new int[this.x.length - 1];
                if (index1 != 0) {
                    System.arraycopy(this.x, 0, y, 0, index1);
                }
                if (index1 != this.x.length - 1) {
                    System.arraycopy(this.x, index1 + 1, y, index1, this.x.length - (index1 + 1));
                }
                this.x = y;
                double[] d = new double[this.values.length - 1];
                if (index1 != 0) {
                    System.arraycopy(this.values, 0, d, 0, index1);
                }
                if (index1 != this.values.length - 1) {
                    System.arraycopy(this.values, index1 + 1, d, index1, this.values.length - (index1 + 1));
                }
                this.values = d;
                --this.counter;
            }
        } else if (index1 < 0) {
            if (this.counter >= this.x.length) {
                int[] y = new int[this.x.length + 1];
                System.arraycopy(this.x, 0, y, 0, this.x.length);
                this.x = y;
                double[] d = new double[this.values.length + 1];
                System.arraycopy(this.values, 0, d, 0, this.values.length);
                this.values = d;
            }
            this.x[this.counter] = index;
            this.values[this.counter] = value;
            if (this.counter > 0 && index < this.x[this.counter - 1]) {
                this.sort(0, this.x.length);
            }
            ++this.counter;
        } else {
            this.values[index1] = value;
        }
    }

    public int[] getNonDefaultIndices() {
        return this.x;
    }

    public double[] getNonDefaultValues() {
        this.trim();
        return this.values;
    }

    public void ensureNumberOfColumns(int numberOfColumns) {
    }

    public void trim() {
        if (this.counter < this.x.length) {
            int[] y = new int[this.counter];
            System.arraycopy(this.x, 0, y, 0, this.counter);
            this.x = y;
            double[] d = new double[this.counter];
            System.arraycopy(this.values, 0, d, 0, this.counter);
            this.values = d;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.x.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.x[i] + ":" + this.values[i]);
        }
        result.append(", counter: " + this.counter);
        return result.toString();
    }
}

