/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;

public class RandomDataRowReader
implements DataRowReader {
    private Iterator iterator;
    private int size;
    private Attribute[] attributes;
    private int counter = 0;

    public RandomDataRowReader(Attribute[] attributes, int size) {
        this.attributes = attributes;
        this.size = size;
    }

    public boolean hasNext() {
        return this.counter < this.size;
    }

    public DataRow next() {
        RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
        double[] data = new double[this.attributes.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = random.nextDoubleInRange(this.attributes[i].getMinimum(), this.attributes[i].getMaximum());
        }
        return new DoubleArrayDataRow(data);
    }
}

