/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractAttribute;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.tools.Tools;
import java.util.Collection;

public class NumericalAttribute
extends AbstractAttribute {
    private double maximum;
    private double minimum;
    private double average;
    private double variance;

    protected NumericalAttribute(String name) {
        this(name, 2);
    }

    protected NumericalAttribute(String name, int valueType) {
        super(name, valueType);
    }

    public Object clone() {
        NumericalAttribute attribute = new NumericalAttribute(this.getName(), this.getValueType());
        attribute.copyProperties(this);
        return attribute;
    }

    public void copyProperties(Attribute attribute) {
        super.copyProperties(attribute);
        if (attribute instanceof NumericalAttribute) {
            NumericalAttribute a = (NumericalAttribute)attribute;
            this.maximum = a.maximum;
            this.minimum = a.minimum;
            this.average = a.average;
            this.variance = a.variance;
        }
    }

    public double getAverage() {
        return this.average;
    }

    public void setAverage(double a) {
        this.average = a;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double v) {
        this.variance = v;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double m) {
        this.maximum = m;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double m) {
        this.minimum = m;
    }

    public boolean isNominal() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean isBooleanClassification() {
        return false;
    }

    public boolean isDefault(double value) {
        return value == 0.0;
    }

    public void setMode(String mode) {
        this.throwNonNominalException("numerical attributes do not have a mode value");
    }

    public String getMode() {
        this.throwNonNominalException("numerical attributes do not have a mode value");
        return null;
    }

    public void clearMaps() {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
    }

    public int mapString(String str) {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return -1;
    }

    public int getIndex(String str) {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return -1;
    }

    public String mapIndex(int index) {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return null;
    }

    public void replaceValue(String oldValue, String newValue) {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
    }

    public int getValueCount(String value) {
        this.throwNonNominalException("numerical attributes do not have countable values");
        return -1;
    }

    public void setIndexToCounterMap(int[] indexToCounterMap) {
        this.throwNonNominalException("numerical attributes do not have countable values");
    }

    public int getNegativeIndex() {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return -1;
    }

    public int getPositiveIndex() {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return -1;
    }

    public Collection getValues() {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return null;
    }

    public int getNumberOfValues() {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
        return -1;
    }

    public void sortNominalMappings() {
        this.throwNonNominalException("numerical attributes do not have nominal value mappings");
    }

    public String getAsString(double value, int numberOfDigits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        return numberOfDigits >= 0 ? Tools.formatNumber(value, numberOfDigits) : value + "";
    }

    public String getRangeString() {
        StringBuffer str = new StringBuffer();
        str.append("avg = " + Tools.formatNumber(this.average) + " +/- " + Tools.formatNumber(Math.sqrt(this.variance)) + "; range = [" + Tools.formatNumber(this.minimum) + " ; " + Tools.formatNumber(this.maximum) + "]");
        int unknownCounter = this.getUnknownCounter();
        if (unknownCounter > 0) {
            str.append("; unknown values = " + unknownCounter);
        }
        return str.toString();
    }

    private void throwNonNominalException(String message) {
        throw new RuntimeException("Attribute " + this.toString() + " is not a nominal attribute: " + message);
    }
}

