/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractAttribute;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.BinaryAttribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NominalAttribute
extends AbstractAttribute {
    private static final int MAX_NUMBER_OF_SHOWN_NOMINAL_VALUES = 5;
    private String mode;
    private Map symbolToIndexMap = new HashMap();
    private List indexToSymbolMap = new ArrayList();
    private int[] indexToCounterMap;

    protected NominalAttribute(String name) {
        this(name, 1);
    }

    protected NominalAttribute(String name, int valueType) {
        super(name, valueType);
    }

    public Object clone() {
        NominalAttribute attribute = new NominalAttribute(this.getName(), this.getValueType());
        attribute.copyProperties(this);
        return attribute;
    }

    public void copyProperties(Attribute attribute) {
        super.copyProperties(attribute);
        if (attribute instanceof NominalAttribute) {
            NominalAttribute a = (NominalAttribute)attribute;
            this.mode = a.mode;
            this.symbolToIndexMap = new HashMap();
            this.symbolToIndexMap.putAll(a.symbolToIndexMap);
            this.indexToSymbolMap = new ArrayList(a.indexToSymbolMap);
            if (a.indexToCounterMap != null) {
                this.indexToCounterMap = new int[a.indexToCounterMap.length];
                System.arraycopy(a.indexToCounterMap, 0, this.indexToCounterMap, 0, a.indexToCounterMap.length);
            }
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute a = (BinaryAttribute)attribute;
            this.mode = a.getMode();
            this.symbolToIndexMap = new HashMap();
            this.mapString(a.mapIndex(0));
            this.mapString(a.mapIndex(1));
            this.indexToSymbolMap.clear();
            this.indexToSymbolMap.add(a.mapIndex(0));
            this.indexToSymbolMap.add(a.mapIndex(1));
            int[] nArray = new int[2];
            nArray[0] = a.getValueCount(a.mapIndex(0));
            nArray[1] = a.getValueCount(a.mapIndex(1));
            this.indexToCounterMap = nArray;
        }
    }

    public void writeAttributeData(DataOutput out) throws IOException {
        super.writeAttributeData(out);
        out.writeInt(this.getNumberOfValues());
        Iterator i = this.getValues().iterator();
        while (i.hasNext()) {
            out.writeUTF((String)i.next());
        }
    }

    public void readAttributeData(DataInput in) throws IOException {
        super.readAttributeData(in);
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            this.mapString(in.readUTF());
        }
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public double getAverage() {
        this.throwNonNumericalException("average cannot be used");
        return Double.NaN;
    }

    public void setAverage(double a) {
        this.throwNonNumericalException("average cannot be used");
    }

    public double getVariance() {
        this.throwNonNumericalException("variance cannot be used");
        return Double.NaN;
    }

    public void setVariance(double v) {
        this.throwNonNumericalException("variance cannot be used");
    }

    public double getMaximum() {
        this.throwNonNumericalException("maximum cannot be used");
        return Double.NaN;
    }

    public void setMaximum(double v) {
        this.throwNonNumericalException("maximum cannot be used");
    }

    public double getMinimum() {
        this.throwNonNumericalException("minimum cannot be used");
        return Double.NaN;
    }

    public void setMinimum(double v) {
        this.throwNonNumericalException("minimum cannot be used");
    }

    public boolean isNominal() {
        return true;
    }

    public boolean isNumerical() {
        return false;
    }

    public boolean isBooleanClassification() {
        return this.getNumberOfValues() == 2;
    }

    public void clearMaps() {
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
        this.indexToCounterMap = null;
    }

    public int mapString(String str) {
        if (str == null) {
            return -1;
        }
        int index = this.getIndex(str);
        if (index < 0) {
            this.indexToSymbolMap.add(str);
            index = this.indexToSymbolMap.size() - 1;
            this.symbolToIndexMap.put(str, new int[]{index});
        }
        return index;
    }

    public int getIndex(String str) {
        int[] index = (int[])this.symbolToIndexMap.get(str);
        if (index == null) {
            return -1;
        }
        return index[0];
    }

    public String mapIndex(int index) {
        if (index < 0 || index >= this.indexToSymbolMap.size()) {
            throw new RuntimeException("Cannot map index of nominal attribute to nominal value: index " + index + " is out of bounds!");
        }
        return (String)this.indexToSymbolMap.get(index);
    }

    public void replaceValue(String oldValue, String newValue) {
        int[] index = (int[])this.symbolToIndexMap.remove(oldValue);
        this.symbolToIndexMap.put(newValue, index);
        this.indexToSymbolMap.set(index[0], newValue);
    }

    public int getValueCount(String value) {
        int index = this.mapString(value);
        if (this.indexToCounterMap != null && (index >= 0 || index < this.indexToCounterMap.length)) {
            return this.indexToCounterMap[index];
        }
        return 0;
    }

    public void setIndexToCounterMap(int[] indexToCounterMap) {
        this.indexToCounterMap = indexToCounterMap;
    }

    public String getAsString(double value, int digits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        return this.mapIndex((int)value);
    }

    public int getNegativeIndex() {
        this.ensureClassification();
        if (this.mapIndex(0) == null) {
            throw new RuntimeException("Attribute: Cannot use FIRST_CLASS_INDEX for negative class!");
        }
        return 0;
    }

    public int getPositiveIndex() {
        this.ensureClassification();
        if (this.mapIndex(0) == null) {
            throw new RuntimeException("Attribute: Cannot use FIRST_CLASS_INDEX for negative class!");
        }
        Iterator i = this.symbolToIndexMap.values().iterator();
        while (i.hasNext()) {
            int[] index = (int[])i.next();
            if (index[0] == 0) continue;
            return index[0];
        }
        throw new RuntimeException("Attribute: No other class than FIRST_CLASS_INDEX found!");
    }

    public Collection getValues() {
        return this.indexToSymbolMap;
    }

    public int getNumberOfValues() {
        return this.indexToSymbolMap.size();
    }

    public boolean isDefault(double value) {
        return value == 0.0;
    }

    public void sortNominalMappings() {
        LinkedList allStrings = new LinkedList(this.symbolToIndexMap.keySet());
        Collections.sort(allStrings);
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
        Iterator i = allStrings.iterator();
        while (i.hasNext()) {
            this.mapString((String)i.next());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("/values=[");
        Iterator i = this.getValues().iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index >= 5) {
                result.append(", ... (" + (this.getValues().size() - 5) + " values) ...");
                break;
            }
            if (index != 0) {
                result.append(", ");
            }
            result.append(i.next());
            ++index;
        }
        result.append("]");
        this.getValues();
        return result.toString();
    }

    public String getRangeString() {
        int unknownCounter;
        StringBuffer str = new StringBuffer();
        str.append("mode = " + this.mode + "; ");
        Collection allValues = this.getValues();
        Iterator i = allValues.iterator();
        int n = 0;
        while (i.hasNext()) {
            if (n >= 5 && n < allValues.size() - 1) {
                str.append(" ... (" + (allValues.size() - 5) + " values) ...");
                break;
            }
            if (n > 0) {
                str.append(", ");
            }
            ++n;
            String value = (String)i.next();
            str.append(value);
            str.append(" (" + this.getValueCount(value) + ")");
        }
        if ((unknownCounter = this.getUnknownCounter()) > 0) {
            str.append("; unknown values = " + unknownCounter);
        }
        return str.toString();
    }

    private void throwNonNumericalException(String message) {
        throw new RuntimeException("Attribute " + this.toString() + " is not a numerical attribute: " + message);
    }

    private void ensureClassification() {
        if (!this.isBooleanClassification()) {
            throw new RuntimeException("Attribute " + this.toString() + " is not a classification attribute!");
        }
    }
}

