/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DatabaseDataRow;
import edu.udo.cs.yale.example.DatabaseDataRowReader;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.tools.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DatabaseExampleTable
extends ExampleTable {
    private DatabaseHandler databaseHandler;
    private String tableName;
    private int numOfColumns;
    private int size;

    private DatabaseExampleTable(List attributes, DatabaseHandler databaseHandler, ResultSet resultSet, String tableName, int numOfColumns) throws SQLException {
        super(attributes);
        Attribute attribute;
        int n;
        this.databaseHandler = databaseHandler;
        this.tableName = tableName;
        this.numOfColumns = numOfColumns;
        this.size = 0;
        int numberOfAttributes = attributes.size();
        double[] minimum = new double[numberOfAttributes];
        double[] maximum = new double[numberOfAttributes];
        double[] average = new double[numberOfAttributes];
        for (n = 0; n < numberOfAttributes; ++n) {
            minimum[n] = Double.POSITIVE_INFINITY;
            maximum[n] = Double.NEGATIVE_INFINITY;
            average[n] = 0.0;
        }
        while (resultSet.next()) {
            for (n = 0; n < numberOfAttributes; ++n) {
                attribute = (Attribute)attributes.get(n);
                double value = DatabaseDataRow.readColumn(resultSet, attribute);
                if (Double.isNaN(value)) continue;
                if (minimum[n] > value) {
                    minimum[n] = value;
                }
                if (maximum[n] < value) {
                    maximum[n] = value;
                }
                int n2 = n;
                average[n2] = average[n2] + value;
            }
            ++this.size;
        }
        for (n = 0; n < numberOfAttributes; ++n) {
            int n3 = n;
            average[n3] = average[n3] / (double)this.size;
            attribute = (Attribute)attributes.get(n);
            attribute.setMinimum(minimum[n]);
            attribute.setMaximum(maximum[n]);
            attribute.setAverage(average[n]);
        }
    }

    public static DatabaseExampleTable createDatabaseExampleTable(DatabaseHandler databaseHandler, String tableName) throws SQLException {
        ResultSet resultSet = databaseHandler.query("select * from " + tableName);
        List attributes = DatabaseHandler.createAttributes(resultSet);
        DatabaseExampleTable table = new DatabaseExampleTable(attributes, databaseHandler, resultSet, tableName, resultSet.getMetaData().getColumnCount());
        resultSet.close();
        return table;
    }

    public DataRowReader getDataReader() {
        try {
            String query = "SELECT ";
            boolean first = true;
            for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                Attribute a = this.getAttribute(i);
                if (a == null) continue;
                if (!first) {
                    query = query + ", ";
                }
                first = false;
                query = query + "\"" + DatabaseHandler.getDatabaseName(a) + "\"";
            }
            query = query + " from " + this.tableName;
            return new DatabaseDataRowReader(this.getAttributes(), this.databaseHandler.query(query));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while creating database datarowreader: " + e, e);
        }
    }

    public DataRow getDataRow(int index) {
        int counter = 0;
        DataRowReader reader = this.getDataReader();
        while (reader.hasNext()) {
            DataRow current = reader.next();
            if (counter < index) continue;
            return current;
        }
        ((DatabaseDataRowReader)reader).close();
        return null;
    }

    public int addAttribute(Attribute attribute) {
        int index = super.addAttribute(attribute);
        if (this.databaseHandler == null) {
            return index;
        }
        try {
            this.databaseHandler.addColumn(attribute, this.tableName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while adding a column to database: " + e, e);
        }
        return index;
    }

    public void removeAttribute(Attribute attribute) {
        super.removeAttribute(attribute);
        try {
            this.databaseHandler.removeColumn(attribute, this.tableName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while removing a column from database: " + e, e);
        }
    }

    public int getSize() {
        return this.size;
    }
}

