/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DatabaseDataRow;
import edu.udo.cs.yale.tools.LogService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseDataRowReader
implements DataRowReader {
    private Attribute[] attributes;
    private ResultSet resultSet;
    private static final int DONT_KNOW_YET = 0;
    private static final int YES = 1;
    private static final int NO = 2;
    private int hasNext = 0;

    public DatabaseDataRowReader(Attribute[] attributes, ResultSet resultSet) {
        this.resultSet = resultSet;
        this.attributes = attributes;
    }

    public boolean hasNext() {
        switch (this.hasNext) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                try {
                    if (this.resultSet.next()) {
                        this.hasNext = 1;
                        return true;
                    }
                    this.hasNext = 2;
                    this.close();
                    return false;
                }
                catch (SQLException e) {
                    LogService.logException("While reading examples from result set:", e);
                    return false;
                }
            }
        }
        return false;
    }

    public DataRow next() {
        if (this.hasNext()) {
            this.hasNext = 0;
            try {
                return new DatabaseDataRow(this.resultSet);
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Error accessing the result of a query:" + sqle.toString(), sqle);
            }
        }
        return null;
    }

    public void close() {
        try {
            Statement statement = this.resultSet.getStatement();
            if (statement != null) {
                statement.close();
            } else {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error during closing of result set / statement: " + e.toString(), e);
        }
    }
}

