/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class CorrelationMatrix
extends ResultObjectAdapter {
    private double[][] matrix;
    private String[] columnNames;
    private NumberFormat formatter = NumberFormat.getInstance();

    public CorrelationMatrix(String[] columnNames) {
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.columnNames = columnNames;
        this.matrix = new double[columnNames.length][columnNames.length];
    }

    public CorrelationMatrix(ExampleSet exampleSet) {
        this(CorrelationMatrix.getColumnNames(exampleSet));
    }

    private static String[] getColumnNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getNumberOfAttributes()];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = exampleSet.getAttribute(i).getName();
        }
        return attributeNames;
    }

    public void setValue(int i, int j, double value) {
        this.matrix[i][j] = value;
        this.matrix[j][i] = value;
    }

    public double getValue(int i, int j) {
        return this.matrix[i][j];
    }

    public String getName() {
        return "Correlation Matrix";
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer("correlation matrix:\n");
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append("\t" + this.columnNames[i]);
        }
        for (i = 0; i < this.matrix.length; ++i) {
            result.append("\n" + this.columnNames[i]);
            for (int j = 0; j < this.matrix[i].length; ++j) {
                result.append("\t" + this.formatter.format(this.matrix[i][j]));
            }
        }
        return result.toString();
    }

    public String toHTML() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("<table bgcolor=\"#E3D8C3\" border=\"1\"><tr bgcolor=\"#ccccff\"><td></td>");
        for (i = 0; i < this.columnNames.length; ++i) {
            result.append("<td><b>" + this.columnNames[i] + "</b></td>");
        }
        result.append("</tr>");
        for (i = 0; i < this.matrix.length; ++i) {
            result.append("<tr><td bgcolor=\"#ccccff\"><b>" + this.columnNames[i] + "</b></td>");
            for (int j = 0; j < this.matrix[i].length; ++j) {
                result.append("<td>" + this.formatter.format(this.matrix[i][j]) + "</td>");
            }
            result.append("</tr>");
        }
        result.append("</table>");
        return result.toString();
    }

    public Component getVisualisationComponent() {
        JLabel label = new JLabel("<html><h1>" + this.getName() + "</h1><pre>" + this.toHTML() + "</pre></html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }
}

