/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleSetAdapter;
import edu.udo.cs.yale.example.ScalingWeightApplier;
import edu.udo.cs.yale.example.WeightApplier;
import edu.udo.cs.yale.example.WeightingExampleReader;

public class AttributeWeightedExampleSet
extends ExampleSetAdapter {
    private WeightApplier weightApplier = new ScalingWeightApplier();
    private Attribute[] currentSelectedAttributes = null;
    private AttributeWeights attributeWeights = new AttributeWeights();

    public AttributeWeightedExampleSet(AttributeWeightedExampleSet exampleSet) {
        super(exampleSet);
        this.weightApplier = exampleSet.weightApplier;
        this.attributeWeights = (AttributeWeights)exampleSet.attributeWeights.clone();
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet) {
        this(exampleSet, null);
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet, AttributeWeights weights) {
        this(exampleSet, weights, 1.0);
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet, AttributeWeights weights, double defaultWeight) {
        super(exampleSet);
        if (weights == null) {
            this.attributeWeights = new AttributeWeights();
            for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                this.attributeWeights.setWeight(this.getAttribute(i).getName(), defaultWeight);
            }
        } else {
            this.attributeWeights = weights;
            for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                double weight = weights.getWeight(this.getAttribute(i).getName());
                this.attributeWeights.setWeight(this.getAttribute(i).getName(), Double.isNaN(weight) ? defaultWeight : weight);
            }
        }
    }

    public void setWeightApplier(WeightApplier weightApplier) {
        this.weightApplier = weightApplier;
    }

    public double getWeight(Attribute attribute) {
        if (!this.contains(attribute)) {
            throw new RuntimeException("Asking a weight for an attribute not in this example set: " + attribute.getName());
        }
        double weight = this.attributeWeights.getWeight(attribute.getName());
        if (Double.isNaN(weight)) {
            throw new RuntimeException("Attribute " + attribute.getName() + " is not a regular attribute in this example set!");
        }
        return weight;
    }

    public void setWeight(Attribute attribute, double weightValue) {
        this.attributeWeights.setWeight(attribute.getName(), weightValue);
        this.clearUserData();
        this.currentSelectedAttributes = null;
    }

    public int getNumberOfUsedAttributes() {
        int counter = 0;
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            Attribute attribute = this.getAttribute(i);
            if (this.getWeight(i) == 0.0) continue;
            ++counter;
        }
        return counter;
    }

    public double getWeight(int i) {
        return this.getWeight(this.getAttribute(i));
    }

    public void setWeight(int index, double weight) {
        this.setWeight(this.getAttribute(index), weight);
    }

    public void selectAll() {
        this.setAll(1.0);
    }

    public void deselectAll() {
        this.setAll(0.0);
    }

    private void setAll(double weight) {
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            this.setWeight(this.getAttribute(i), weight);
        }
    }

    public int setWeightForBlock(int index, double weight) {
        return this.setWeightForBlock(this.getAttribute(index), weight);
    }

    public int setWeightForBlock(Attribute attribute, double weight) {
        if (attribute.getBlockNumber() != -1) {
            if (!attribute.isSeries()) {
                throw new RuntimeException("Attribute " + attribute.getName() + " is a single value and should not have a blocknumber!");
            }
            if (attribute.isBlockStart()) {
                int startIndex = attribute.getTableIndex();
                int endIndex = this.getExampleTable().getBlockEndIndex(startIndex);
                for (int i = startIndex; i <= endIndex; ++i) {
                    Attribute blockAtt = this.getExampleTable().getAttribute(i);
                    if (!blockAtt.isSeries()) {
                        throw new RuntimeException("Attribute " + blockAtt.getName() + " is a single value and should not have a blocknumber!");
                    }
                    this.setWeight(blockAtt, weight);
                }
                return endIndex;
            }
            return attribute.getTableIndex();
        }
        this.setWeight(attribute, weight);
        return attribute.getTableIndex();
    }

    public boolean isAttributeUsed(Attribute attribute) {
        return this.getWeight(attribute) != 0.0;
    }

    public void setAttributeUsed(Attribute attribute, boolean selected) {
        this.setWeight(attribute, selected ? 1.0 : 0.0);
    }

    public int flipAttributeUsed(int index) {
        return this.flipAttributeUsed(this.getAttribute(index));
    }

    public int flipAttributeUsed(Attribute attribute) {
        return this.setWeightForBlock(attribute, this.isAttributeUsed(attribute) ? 0.0 : 1.0);
    }

    public boolean isAttributeUsed(int i) {
        return this.isAttributeUsed(this.getAttribute(i));
    }

    public void setAttributeUsed(int index, boolean selected) {
        this.setAttributeUsed(this.getAttribute(index), selected);
    }

    public void addAttribute(Attribute attribute) {
        super.addAttribute(attribute);
        this.attributeWeights.setWeight(attribute.getName(), 1.0);
        this.clearUserData();
        this.currentSelectedAttributes = null;
    }

    public void removeAttribute(Attribute attribute) {
        super.removeAttribute(attribute);
        this.attributeWeights.setWeight(attribute.getName(), Double.NaN);
        this.clearUserData();
        this.currentSelectedAttributes = null;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeWeightedExampleSet)) {
            return false;
        }
        AttributeWeightedExampleSet es = (AttributeWeightedExampleSet)o;
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (es.getWeight(i) == this.getWeight(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("\nWeights: ");
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            if (i > 50) {
                buffer.append("...");
                break;
            }
            buffer.append(this.getAttribute(i).getName() + ":" + this.getWeight(i));
        }
        return buffer.toString();
    }

    public ExampleReader getExampleReader() {
        ExampleSet selectionSet = this.createExampleSetFromSelection();
        return new WeightingExampleReader(selectionSet.getExampleReader(), selectionSet, this.attributeWeights, this.weightApplier);
    }

    public Example getExample(int index) {
        if (this.currentSelectedAttributes == null) {
            ExampleSet selectionSet = this.createExampleSetFromSelection();
            this.currentSelectedAttributes = new Attribute[selectionSet.getNumberOfAttributes()];
            for (int i = 0; i < this.currentSelectedAttributes.length; ++i) {
                this.currentSelectedAttributes[i] = selectionSet.getAttribute(i);
            }
        }
        return new Example(super.getExample(index).getDataRow(), this.currentSelectedAttributes, this.getSpecialAttributes(), this.attributeWeights, this.weightApplier);
    }

    public AttributeWeightedExampleSet createCleanExampleSet() {
        AttributeWeightedExampleSet result = (AttributeWeightedExampleSet)this.clone();
        result.setWeightApplier(this.weightApplier);
        for (int i = result.getNumberOfAttributes() - 1; i >= 0; --i) {
            Attribute attribute = result.getAttribute(i);
            if (result.getWeight(attribute) != 0.0) continue;
            result.removeAttribute(attribute);
        }
        return result;
    }

    public ExampleSet createExampleSetFromSelection() {
        ExampleSet eSet = (ExampleSet)this.delegate.clone();
        for (int i = eSet.getNumberOfAttributes() - 1; i >= 0; --i) {
            Attribute attribute = eSet.getAttribute(i);
            if (this.getWeight(attribute) != 0.0) continue;
            eSet.removeAttribute(attribute);
        }
        return eSet;
    }

    public ExampleSet createExampleSetFromWeights() {
        ExampleSet eSet = (ExampleSet)this.delegate.clone();
        for (int i = eSet.getNumberOfAttributes() - 1; i >= 0; --i) {
            Attribute attribute = eSet.getAttribute(i);
            double weight = this.getWeight(attribute);
            if (weight == 0.0) {
                eSet.removeAttribute(attribute);
                continue;
            }
            if (!attribute.isNumerical()) continue;
            ExampleReader reader = eSet.getExampleReader();
            while (reader.hasNext()) {
                Example example = reader.next();
                example.setValue(attribute, this.weightApplier.applyWeight(example.getValue(attribute), weight));
            }
        }
        return eSet;
    }
}

