/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.tools.LogService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AttributeParser {
    public static final String NAME_CONSTRUCTION_DESC_SEP = "::";
    private Map allAttributes = new HashMap();
    private List newAttributes = new LinkedList();
    private ExampleTable exampleTable;

    public AttributeParser(ExampleTable et) {
        this.exampleTable = et;
        for (int i = 0; i < this.exampleTable.getNumberOfAttributes(); ++i) {
            Attribute a = this.exampleTable.getAttribute(i);
            if (a == null) continue;
            this.addAttribute(a);
        }
    }

    private Collection getAttributes() {
        return this.allAttributes.values();
    }

    public List getNewAttributes() {
        return this.newAttributes;
    }

    public Attribute parse(String string) throws GenerationException {
        String attributeName = null;
        String attributeString = null;
        int nameIndex = string.indexOf(NAME_CONSTRUCTION_DESC_SEP);
        int commaIndex = string.indexOf(",");
        if (nameIndex != -1) {
            attributeName = string.substring(0, nameIndex).trim();
            attributeString = string.substring(nameIndex + NAME_CONSTRUCTION_DESC_SEP.length()).trim();
        } else {
            attributeString = string;
        }
        Attribute att = this.parseAttribute(attributeString);
        if (attributeName != null) {
            att.setName(attributeName);
        }
        this.newAttributes.add(att);
        return att;
    }

    public void parseAll(Reader reader) throws IOException, GenerationException {
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        while ((line = in.readLine()) != null) {
            this.parse(line);
        }
        in.close();
    }

    private Attribute addAttribute(Attribute a) {
        Attribute oldAtt = (Attribute)this.allAttributes.get(a.getConstructionDescription());
        if (oldAtt != null) {
            return oldAtt;
        }
        this.allAttributes.put(a.getConstructionDescription(), a);
        return a;
    }

    private static int getClosingBracketIndex(String string, int startIndex) throws GenerationException {
        int nextClosing;
        int openCount = 1;
        do {
            int nextOpen = string.indexOf("(", startIndex + 1);
            nextClosing = string.indexOf(")", startIndex + 1);
            if (nextClosing == -1) {
                throw new GenerationException("Malformed attribute description: mismatched parantheses");
            }
            if (nextOpen != -1 && nextOpen < nextClosing) {
                ++openCount;
                startIndex = nextOpen;
                continue;
            }
            --openCount;
            startIndex = nextClosing;
        } while (openCount != 0);
        return nextClosing;
    }

    private Attribute parseAttribute(String string) throws GenerationException {
        Attribute[] attributes = this.parseAttributes(string);
        if (attributes.length != 1) {
            throw new GenerationException("Malformed function description: too many attributes");
        }
        return attributes[0];
    }

    private Attribute[] parseAttributes(String string) throws GenerationException {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int start = 0;
        while (start < string.length()) {
            Attribute attribute;
            String name;
            int end;
            int leftBr = string.indexOf("(", start);
            int comma = string.indexOf(",", start);
            if (comma == -1 && leftBr == -1) {
                end = string.length();
                name = string.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments!");
                }
                attribute = AttributeFactory.createAttribute(name, 2);
                attributes.add(this.addAttribute(attribute));
                start = string.length();
                continue;
            }
            if (leftBr == -1 || comma < leftBr && comma != -1) {
                end = comma;
                name = string.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments!");
                }
                attribute = AttributeFactory.createAttribute(name, 2);
                attributes.add(this.addAttribute(attribute));
                start = end + 1;
                continue;
            }
            int rightBr = AttributeParser.getClosingBracketIndex(string, leftBr);
            String functionName = string.substring(start, leftBr).trim();
            Attribute[] arguments = this.parseAttributes(string.substring(leftBr + 1, rightBr).trim());
            attributes.add(this.addAttribute(AttributeFactory.createAttribute(functionName, arguments)));
            start = string.indexOf(",", rightBr) + 1;
            if (start > 0) continue;
            start = string.length();
        }
        Attribute[] attributeArray = new Attribute[attributes.size()];
        attributes.toArray(attributeArray);
        return attributeArray;
    }

    private Collection applicableGenerators() throws GenerationException {
        HashSet<FeatureGenerator> generators = new HashSet<FeatureGenerator>();
        Iterator i = this.allAttributes.values().iterator();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            if (this.exampleTable.getAttribute(a) == null) {
                FeatureGenerator fg;
                if (!this.argumentsAlreadyGenerated(a) || (fg = FeatureGenerator.createGeneratorForFunction(a.getFunctionName())) == null) continue;
                Attribute[] args = a.getArguments();
                if (args != null) {
                    for (int n = 0; n < args.length; ++n) {
                        args[n] = this.exampleTable.getAttribute(args[n]);
                    }
                    if (fg.getInputAttributes().length != args.length) {
                        throw new GenerationException(fg + " has arity " + fg.getInputAttributes().length + "!");
                    }
                    fg.setArguments(args);
                }
                generators.add(fg);
                i.remove();
                continue;
            }
            i.remove();
        }
        return generators;
    }

    private boolean argumentsAlreadyGenerated(Attribute a) {
        Attribute[] arguments = a.getArguments();
        if (arguments == null) {
            return true;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (this.exampleTable.getAttribute(arguments[i]) != null) continue;
            return false;
        }
        return true;
    }

    public void generateAll(ExampleSet exampleSet) throws GenerationException {
        Collection generators;
        LinkedList allGeneratedAttributes = new LinkedList();
        while ((generators = this.applicableGenerators()).size() > 0) {
            List generatedAtts = FeatureGenerator.generateAll(this.exampleTable, generators);
            allGeneratedAttributes.addAll(generatedAtts);
        }
        Iterator<Object> i = this.allAttributes.values().iterator();
        while (i.hasNext()) {
            LogService.logMessage("Could not generate attribute " + i.next(), 6);
        }
        if (this.allAttributes.size() > 0) {
            throw new GenerationException("Couldn't generate all attributes! Failing: " + this.allAttributes);
        }
        i = this.newAttributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            Iterator k = allGeneratedAttributes.iterator();
            Attribute generatedAttribute = null;
            while (k.hasNext()) {
                Attribute currentAttribute = (Attribute)k.next();
                if (!currentAttribute.equalConstructionDescription(attribute)) continue;
                generatedAttribute = currentAttribute;
                break;
            }
            if (generatedAttribute == null) continue;
            generatedAttribute.setName(attribute.getName());
            if (exampleSet.contains(generatedAttribute)) continue;
            exampleSet.addAttribute(generatedAttribute);
        }
        allGeneratedAttributes.removeAll(this.newAttributes);
        LogService.logMessage("Removing " + allGeneratedAttributes.size() + " intermediate attributes.", 0);
        i = allGeneratedAttributes.iterator();
        while (i.hasNext()) {
            this.exampleTable.removeAttribute((Attribute)i.next());
        }
    }
}

