/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.DataViewer;
import edu.udo.cs.yale.gui.MetaDataViewer;
import edu.udo.cs.yale.gui.PlotterPanel;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class AbstractExampleSet
extends ResultObjectAdapter
implements ExampleSet,
Saveable {
    public AbstractExampleSet() {
    }

    public AbstractExampleSet(AbstractExampleSet exampleSet) {
    }

    public void addAllAttributes(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (this.contains(attribute)) continue;
            this.addAttribute(attribute);
        }
    }

    public void removeAllAttributes() {
        while (this.getNumberOfAttributes() > 0) {
            this.removeAttribute(this.getAttribute(0));
        }
    }

    public Attribute removeAttribute(int index) {
        Attribute attr = this.getAttribute(index);
        this.removeAttribute(attr);
        return attr;
    }

    public void setAttributes(ExampleSet exampleSet) {
        this.removeAllAttributes();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            this.addAttribute(exampleSet.getAttribute(i));
        }
    }

    public Attribute getLabel() {
        return this.getAttribute("label");
    }

    public void setLabel(Attribute label) {
        this.setSpecialAttribute("label", label);
    }

    public Attribute getPredictedLabel() {
        return this.getAttribute("prediction");
    }

    public void setPredictedLabel(Attribute predictedLabel) {
        this.setSpecialAttribute("prediction", predictedLabel);
    }

    public void clearPredictedLabel() {
        this.setSpecialAttribute("prediction", null);
    }

    public Attribute getWeight() {
        return this.getAttribute("weight");
    }

    public void setWeight(Attribute weight) {
        this.setSpecialAttribute("weight", weight);
    }

    public Attribute getCluster() {
        return this.getAttribute("cluster");
    }

    public void setCluster(Attribute cluster) {
        this.setSpecialAttribute("cluster", cluster);
    }

    public Attribute getId() {
        return this.getAttribute("id");
    }

    public void setId(Attribute idAttribute) {
        this.setSpecialAttribute("id", idAttribute);
    }

    public Attribute createWeightAttribute() {
        Attribute weight = this.getWeight();
        if (weight != null) {
            LogService.logMessage("ExampleSet.createWeightAttribute(): Overwriting old weight attribute!", 4);
        }
        weight = this.createSpecialAttribute("weight", 4);
        DataRowReader reader = this.getExampleTable().getDataReader();
        while (reader.hasNext()) {
            DataRow data = reader.next();
            data.set(weight, 1.0);
        }
        return weight;
    }

    public Attribute createClusterAttribute() {
        Attribute cluster = this.getCluster();
        if (cluster != null) {
            LogService.logMessage("ExampleSet.createClusterAttribute(): Overwriting old cluster attribute!", 4);
        }
        return this.createSpecialAttribute("cluster", 6);
    }

    public Attribute createSpecialAttribute(String name, int valueType) {
        Attribute attribute = AttributeFactory.createAttribute(AttributeFactory.createName(name), valueType);
        this.getExampleTable().addAttribute(attribute);
        this.setSpecialAttribute(name, attribute);
        return attribute;
    }

    public boolean contains(Attribute attribute) {
        return this.getAttribute(attribute.getName()) != null;
    }

    public boolean containsValueType(int valueType) {
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.getAttribute(i).getValueType(), valueType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(Tools.classNameWOPackage(this.getClass()) + ": ");
        str.append(this.getSize() + " examples\n");
        str.append("       attributes = {\n");
        if (this.getNumberOfAttributes() >= AbstractExampleSet.getAttributeLimit()) {
            str.append("..." + this.getNumberOfAttributes() + " attributes...");
        } else {
            for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                Attribute att = this.getAttribute(i);
                str.append((i == 0 ? "" : ",\n") + "         " + ((Object)att).toString());
                if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(att.getBlockType(), 7)) continue;
                int end = this.getBlockEndIndex(i);
                str.append(",..., " + (end - i - 1) + " attributes,...");
                i = end - 1;
            }
        }
        str.append("\n       }");
        Iterator i = this.getSpecialAttributeNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            str.append("\n       " + name + " = " + this.getAttribute(name));
        }
        return str.toString();
    }

    public static int getAttributeLimit() {
        int attributeLimit = Integer.MAX_VALUE;
        String max = System.getProperty("yale.gui.resultviewer.attributelimit");
        if (max != null) {
            try {
                attributeLimit = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                System.err.println("Value of yale.gui.resultviewer.attributelimit must be an integer!");
            }
        }
        return attributeLimit;
    }

    public static int getExampleLimit() {
        int exampleLimit = Integer.MAX_VALUE;
        String max = System.getProperty("yale.gui.resultviewer.examplelimit");
        if (max != null) {
            try {
                exampleLimit = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                System.err.println("Value of yale.gui.resultviewer.examplelimit must be an integer!");
            }
        }
        return exampleLimit;
    }

    public Component getVisualisationComponent() {
        boolean showPlots = !(this.getSize() > AbstractExampleSet.getExampleLimit() && AbstractExampleSet.getExampleLimit() != -1 || this.getNumberOfAttributes() > AbstractExampleSet.getAttributeLimit() && AbstractExampleSet.getAttributeLimit() != -1);
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        final MetaDataViewer metaDataViewer = new MetaDataViewer(this, AbstractExampleSet.getAttributeLimit());
        final DataViewer dataViewer = new DataViewer(this);
        Statistics stats = new Statistics("Example Set");
        if (showPlots) {
            String[] columnNames = new String[this.getNumberOfAttributes() + this.getSpecialAttributeNames().size()];
            for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                columnNames[i] = this.getAttribute(i).getName();
            }
            Iterator s = this.getSpecialAttributeNames().iterator();
            int k = 0;
            while (s.hasNext()) {
                columnNames[this.getNumberOfAttributes() + k] = (String)s.next();
                ++k;
            }
            stats.init(columnNames);
            ExampleReader reader = this.getExampleReader();
            while (reader.hasNext()) {
                Example example = reader.next();
                Object[] data = new Double[this.getNumberOfAttributes() + this.getSpecialAttributeNames().size()];
                for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
                    data[i] = new Double(example.getValue(this.getAttribute(i)));
                }
                s = this.getSpecialAttributeNames().iterator();
                k = 0;
                while (s.hasNext()) {
                    Attribute specialAtt = this.getAttribute((String)s.next());
                    data[this.getNumberOfAttributes() + k] = new Double(example.getValue(specialAtt));
                    ++k;
                }
                stats.add(this.getId() == null ? null : example.getValueAsString(this.getId()), data);
            }
        }
        final PlotterPanel plotterComponent = showPlots ? new PlotterPanel(stats) : new PlotterPanel(new JLabel("<html>Too many examples or attributes for plot view: " + this.getSize() + " examples and " + this.getNumberOfAttributes() + " attributes.<br>Increase example and / or attribute limit in the settings dialog (example limit: " + AbstractExampleSet.getExampleLimit() + ", attribute limit: " + AbstractExampleSet.getAttributeLimit() + ").<br>Please note, that changing the limits may slow down Yale and increase the memory usage!</html>"));
        final JRadioButton metaDataButton = new JRadioButton("meta data view", true);
        metaDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (metaDataButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)metaDataViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton dataButton = new JRadioButton("data view", true);
        dataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (dataButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)dataViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("plot view", false);
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)plotterComponent, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(metaDataButton);
        group.add(dataButton);
        group.add(plotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(metaDataButton);
        togglePanel.add(dataButton);
        togglePanel.add(plotButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add((Component)metaDataViewer, "Center");
        return mainPanel;
    }

    public int getBlockEndIndex(int startindex) {
        Attribute startAtt = this.getAttribute(startindex);
        if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(startAtt.getBlockType(), 7)) {
            throw new RuntimeException("Attribute  " + startAtt + " is not start of a value series!");
        }
        for (int i = startindex + 1; i < this.getNumberOfAttributes(); ++i) {
            Attribute attribute = this.getAttribute(i);
            if (attribute.getBlockNumber() != startAtt.getBlockNumber()) {
                throw new RuntimeException("Value series has mixed block numbers: " + startAtt.getBlockNumber() + ", " + attribute.getBlockNumber());
            }
            if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getBlockType(), 8)) continue;
            return i;
        }
        throw new RuntimeException("Value series not terminated!");
    }

    public void save(File file) throws IOException {
        File attFile = new File(file.getAbsolutePath() + ".xml");
        this.writeToFile(file, attFile);
    }

    public void writeToFile(File dataFile, File attFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(dataFile));
        ExampleReader reader = this.getExampleReader();
        while (reader.hasNext()) {
            out.println(reader.next().toString());
        }
        out.close();
        if (attFile != null) {
            this.writeAttributeFile(dataFile, attFile);
        }
    }

    public void writeToFileSparse(int format, File dataFile, File attFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(dataFile));
        ExampleReader reader = this.getExampleReader();
        while (reader.hasNext()) {
            out.println(reader.next().toSparseString(format));
        }
        out.close();
        if (attFile != null) {
            this.writeAttributeFileSparse(format, dataFile, attFile);
        }
    }

    private void writeAttributeFile(File dataFile, File attFile) throws IOException {
        PrintWriter aout = new PrintWriter(new FileWriter(attFile));
        aout.println("<attributeset default_source=\"" + dataFile.getAbsolutePath() + "\">");
        int sourcecol = 1;
        for (int j = 0; j < this.getNumberOfAttributes(); ++j) {
            AbstractExampleSet.writeAttributeData("attribute", this.getAttribute(j), sourcecol, aout, false);
            ++sourcecol;
        }
        Iterator i = this.getSpecialAttributes().keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            AbstractExampleSet.writeAttributeData(name, this.getAttribute(name), sourcecol, aout, false);
            ++sourcecol;
        }
        aout.println("</attributeset>");
        aout.close();
    }

    private void writeAttributeFileSparse(int format, File dataFile, File attFile) throws IOException {
        Attribute weightAttribute;
        Attribute idAttribute;
        PrintWriter aout = new PrintWriter(new FileWriter(attFile));
        aout.println("<attributeset default_source=\"" + dataFile.getAbsolutePath() + "\">");
        StringBuffer str = new StringBuffer();
        Attribute labelAttribute = this.getAttribute("label");
        if (labelAttribute != null && format != 4) {
            AbstractExampleSet.writeAttributeData("label", labelAttribute, 0, aout, true);
        }
        if ((idAttribute = this.getAttribute("id")) != null) {
            AbstractExampleSet.writeAttributeData("id", idAttribute, 0, aout, true);
        }
        if ((weightAttribute = this.getAttribute("weight")) != null) {
            AbstractExampleSet.writeAttributeData("weight", weightAttribute, 0, aout, true);
        }
        int sourcecol = 1;
        for (int j = 0; j < this.getNumberOfAttributes(); ++j) {
            AbstractExampleSet.writeAttributeData("attribute", this.getAttribute(j), sourcecol, aout, true);
            ++sourcecol;
        }
        aout.println("</attributeset>");
        aout.close();
    }

    private static void writeAttributeData(String tag, Attribute attribute, int sourcecol, PrintWriter aout, boolean sparse) {
        aout.println("  <" + tag);
        aout.println("    name         = \"" + attribute.getName() + "\"");
        if (!sparse || tag.equals("attribute")) {
            aout.println("    sourcecol    = \"" + sourcecol + "\"");
        }
        aout.println("    valuetype    = \"" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType()) + "\"");
        if (attribute.isNominal()) {
            aout.print("    classes      = \"");
            Iterator i = attribute.getValues().iterator();
            int n = 0;
            while (i.hasNext()) {
                if (n != 0) {
                    aout.print(" ");
                }
                ++n;
                aout.print((String)i.next());
            }
            aout.println("\"");
        }
        aout.println("    blocktype    = \"" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType()) + "\"");
        aout.println("    blocknumber  = \"" + attribute.getBlockNumber() + "\"");
        aout.println("    unit         = \"" + attribute.unitToString() + "\"");
        aout.println("  />");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExampleSet)) {
            return false;
        }
        ExampleSet es = (ExampleSet)o;
        if (es.getNumberOfAttributes() != this.getNumberOfAttributes()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            if (AbstractExampleSet.equals(this.getAttribute(i), es.getAttribute(i))) continue;
            return false;
        }
        if (!AbstractExampleSet.equals(this.getLabel(), es.getLabel())) {
            return false;
        }
        if (!AbstractExampleSet.equals(this.getPredictedLabel(), es.getPredictedLabel())) {
            return false;
        }
        if (!AbstractExampleSet.equals(this.getWeight(), es.getWeight())) {
            return false;
        }
        return AbstractExampleSet.equals(this.getCluster(), es.getCluster());
    }

    private static boolean equals(Attribute a1, Attribute a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return ((Object)a1).equals(a2);
    }

    public IOObject copy() {
        return (IOObject)this.clone();
    }

    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cloneConstructor = clazz.getConstructor(clazz);
            return cloneConstructor.newInstance(this);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("'" + this.getClass().getName() + "' does not implement clone constructor!");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e + ". Target: " + e.getCause() + ". Cause: " + e.getTargetException() + ".");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + throwable);
        }
    }

    public void recalculateAllAttributeStatistics() {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        for (int i = 0; i < this.getNumberOfAttributes(); ++i) {
            allAttributes.add(this.getAttribute(i));
        }
        Iterator i = this.getSpecialAttributeNames().iterator();
        while (i.hasNext()) {
            allAttributes.add(this.getAttribute((String)i.next()));
        }
        this.recalculateAttributeStatistics(allAttributes);
    }

    public void recalculateAttributeStatistics(List attributeList) {
        AttributeStats stats;
        Attribute attribute;
        int attr;
        int numAttributes = attributeList.size();
        AttributeStats[] attributeStats = new AttributeStats[numAttributes];
        for (int attr2 = 0; attr2 < numAttributes; ++attr2) {
            Attribute attribute2 = (Attribute)attributeList.get(attr2);
            attributeStats[attr2] = attribute2.isNominal() ? new NominalAttributeStats(attribute2.getNumberOfValues()) : new NumericalAttributeStats();
        }
        ExampleReader reader = this.getExampleReader();
        Example example = null;
        while ((example = reader.next()) != null) {
            for (attr = 0; attr < numAttributes; ++attr) {
                attribute = (Attribute)attributeList.get(attr);
                stats = attributeStats[attr];
                double value = example.getValue(attribute);
                if (Double.isNaN(value)) {
                    stats.addUnknown();
                    continue;
                }
                if (stats.isNominal()) {
                    ((NominalAttributeStats)stats).addHit((int)value);
                    continue;
                }
                ((NumericalAttributeStats)stats).addValue(value);
            }
        }
        for (attr = 0; attr < numAttributes; ++attr) {
            attribute = (Attribute)attributeList.get(attr);
            stats = attributeStats[attr];
            attribute.setUnknownCounter(stats.getUnknown());
            if (stats.isNominal()) {
                NominalAttributeStats nstats = (NominalAttributeStats)stats;
                attribute.setIndexToCounterMap(nstats.getIndex2CounterMap(attribute));
                attribute.setMode(attribute.mapIndex((int)nstats.mode));
                continue;
            }
            double average = ((NumericalAttributeStats)stats).average / (double)this.getSize();
            double squaredSum = ((NumericalAttributeStats)stats).squaredSum / (double)this.getSize();
            attribute.setMinimum(((NumericalAttributeStats)stats).minimum);
            attribute.setMaximum(((NumericalAttributeStats)stats).maximum);
            attribute.setAverage(average);
            attribute.setVariance(squaredSum - average * average);
        }
    }

    public void recalculateAttributeStatistics(Attribute attribute) {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        allAttributes.add(attribute);
        this.recalculateAttributeStatistics(allAttributes);
    }

    private class NominalAttributeStats
    extends AttributeStats {
        double mode = Double.NaN;
        int maxCounter = 0;
        int[] scores;

        NominalAttributeStats(int maxvalueposition) {
            this.scores = new int[maxvalueposition];
        }

        public void addHit(int index) {
            int n = index;
            this.scores[n] = this.scores[n] + 1;
            if (this.scores[index] > this.maxCounter) {
                this.maxCounter = this.scores[index];
                this.mode = index;
            }
        }

        public int[] getIndex2CounterMap(Attribute attribute) {
            return this.scores;
        }

        public boolean isNominal() {
            return true;
        }
    }

    private class NumericalAttributeStats
    extends AttributeStats {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        double average = 0.0;
        double squaredSum = 0.0;

        private NumericalAttributeStats() {
        }

        public void addValue(double value) {
            if (this.minimum > value) {
                this.minimum = value;
            }
            if (this.maximum < value) {
                this.maximum = value;
            }
            this.average += value;
            this.squaredSum += value * value;
        }

        public boolean isNominal() {
            return false;
        }
    }

    private abstract class AttributeStats {
        private int unknownCounter = 0;

        private AttributeStats() {
        }

        public void addUnknown() {
            ++this.unknownCounter;
        }

        public int getUnknown() {
            return this.unknownCounter;
        }

        public abstract boolean isNominal();
    }
}

