/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.io.IOException;

public class Main
extends Yale
implements BreakpointListener {
    private boolean showLogo = false;
    private String experimentfile = null;
    static /* synthetic */ Class class$edu$udo$cs$yale$Main;

    public void breakpointReached(Operator operator, IOContainer container, int location) {
        System.out.println("Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":\n" + container);
        System.out.println("Breakpoint reached " + (location == 0 ? "before " : "after ") + operator.getName() + ", press enter...");
        new WaitForKeyThread(operator).start();
    }

    public void resume() {
    }

    private void parseArguments(String[] argv) {
        this.experimentfile = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-l")) {
                this.showLogo = true;
                continue;
            }
            this.experimentfile = argv[i];
        }
        if (this.experimentfile == null) {
            Main.printUsage();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: " + (class$edu$udo$cs$yale$Main == null ? (class$edu$udo$cs$yale$Main = Main.class$("edu.udo.cs.yale.Main")) : class$edu$udo$cs$yale$Main).getName() + " EXPERIMENTFILE");
        System.exit(1);
    }

    private void run() {
        try {
            if (this.showLogo) {
                Main.showLogo();
            }
            Main.init();
            if (this.showLogo) {
                Main.hideLogo();
            }
        }
        catch (IOException e) {
            System.err.println("ERROR: Cannot initialize Yale...");
            Main.quit(1);
        }
        try {
            Main.readExperimentFile(new File(this.experimentfile));
        }
        catch (Exception e) {
            System.err.println("ERROR: Cannot read experiment '" + this.experimentfile + "'...");
            Main.quit(1);
        }
        try {
            LogService.init(Main.getExperiment());
            Main.getExperiment().addBreakpointListener(this);
            Main.getExperiment().prepareRun();
            IOContainer results = Main.getExperiment().run();
            Main.getExperiment().getRootOperator().sendEmail(results, null);
            System.err.println("Experiment finished successfully");
            Main.quit(0);
        }
        catch (Throwable e) {
            LogService.logException(null, e);
            LogService.logMessageWithTree("Experiment failed!", 7, Main.getExperiment().getCurrentOperator());
            Main.getExperiment().getRootOperator().sendEmail(null, e);
            System.err.println("Experiment not successful");
            Main.quit(1);
        }
    }

    public static void main(String[] argv) {
        System.out.println(LICENSE);
        Main main = new Main();
        main.parseArguments(argv);
        main.run();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WaitForKeyThread
    extends Thread {
        private Operator operator;

        public WaitForKeyThread(Operator operator) {
            this.operator = operator;
        }

        public void run() {
            try {
                System.in.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.operator.resume();
        }
    }
}

